/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.mdoc;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORPairsBuilder;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORTaggedItem;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class ValidityInfo
extends CBORPairList {
    private static final CBORString LABEL_SIGNED = new CBORString("signed");
    private static final CBORString LABEL_VALID_FROM = new CBORString("validFrom");
    private static final CBORString LABEL_VALID_UNTIL = new CBORString("validUntil");
    private static final CBORString LABEL_EXPECTED_UPDATE = new CBORString("expectedUpdate");

    public ValidityInfo(ZonedDateTime signed, ZonedDateTime validFrom, ZonedDateTime validUntil) {
        this(signed, validFrom, validUntil, null);
    }

    public ValidityInfo(ZonedDateTime signed, ZonedDateTime validFrom, ZonedDateTime validUntil, ZonedDateTime expectedUpdate) {
        super(ValidityInfo.createList(signed, validFrom, validUntil, expectedUpdate));
    }

    private static List<CBORPair> createList(ZonedDateTime signed, ZonedDateTime validFrom, ZonedDateTime validUntil, ZonedDateTime expectedUpdate) {
        return new CBORPairsBuilder().addUnlessNull((CBORItem)LABEL_SIGNED, ValidityInfo.toValue(signed)).addUnlessNull((CBORItem)LABEL_VALID_FROM, ValidityInfo.toValue(validFrom)).addUnlessNull((CBORItem)LABEL_VALID_UNTIL, ValidityInfo.toValue(validUntil)).addUnlessNull((CBORItem)LABEL_EXPECTED_UPDATE, ValidityInfo.toValue(expectedUpdate)).build();
    }

    private static CBORItem toValue(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return new CBORTaggedItem(0, ValidityInfo.buildString(dateTime));
    }

    private static CBORString buildString(ZonedDateTime dateTime) {
        ZonedDateTime dt = dateTime.withZoneSameInstant(ZoneOffset.UTC).withNano(0);
        return new CBORString(dt.format(DateTimeFormatter.ISO_INSTANT));
    }
}

