/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.SDUtility;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Disclosure {
    private final String salt;
    private final String claimName;
    private final Object claimValue;
    private final String json;
    private final String disclosure;
    private final String defaultDigest;
    private final int hashCode;

    public Disclosure(Object claimValue) {
        this(Disclosure.generateSalt(), null, claimValue, null, null);
    }

    public Disclosure(String claimName, Object claimValue) {
        this(Disclosure.generateSalt(), claimName, claimValue, null, null);
    }

    public Disclosure(String salt, String claimName, Object claimValue) {
        this(salt, claimName, claimValue, null, null);
    }

    private Disclosure(String salt, String claimName, Object claimValue, String json, String disclosure) {
        if (salt == null) {
            throw new IllegalArgumentException("'salt' is missing.");
        }
        if (json == null) {
            json = claimName == null ? SDUtility.toJson(List.of(salt, claimValue)) : SDUtility.toJson(List.of(salt, claimName, claimValue));
        }
        if (disclosure == null) {
            disclosure = SDUtility.toBase64url(SDUtility.toUTF8Bytes(json));
        }
        this.salt = salt;
        this.claimName = claimName;
        this.claimValue = claimValue;
        this.json = json;
        this.disclosure = disclosure;
        this.defaultDigest = SDUtility.computeDigest("sha-256", disclosure);
        this.hashCode = Objects.hash(this.getClass(), this.getDisclosure());
    }

    public String getSalt() {
        return this.salt;
    }

    public String getClaimName() {
        return this.claimName;
    }

    public Object getClaimValue() {
        return this.claimValue;
    }

    public String getJson() {
        return this.json;
    }

    public String getDisclosure() {
        return this.disclosure;
    }

    private String getDefaultDigest() {
        return this.defaultDigest;
    }

    public String digest() {
        return this.getDefaultDigest();
    }

    public String digest(String hashAlgorithm) {
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("'hashAlgorithm' is missing.");
        }
        if ("sha-256".equalsIgnoreCase(hashAlgorithm)) {
            return this.getDefaultDigest();
        }
        return SDUtility.computeDigest(hashAlgorithm, this.getDisclosure());
    }

    public String toString() {
        return this.getDisclosure();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disclosure that = (Disclosure)obj;
        return this.getDisclosure().equals(that.getDisclosure());
    }

    public Map<String, Object> toArrayElement() {
        return this.toArrayElement("sha-256");
    }

    public Map<String, Object> toArrayElement(String hashAlgorithm) {
        if (this.getClaimName() != null) {
            throw new IllegalStateException("This disclosure is not for an array element.");
        }
        return Map.of("...", this.digest(hashAlgorithm));
    }

    public static Disclosure parse(String disclosure) {
        if (disclosure == null) {
            return null;
        }
        String json = SDUtility.fromUTF8Bytes(SDUtility.fromBase64url(disclosure));
        List<?> elements = Disclosure.parseAsDisclosureElements(json);
        String salt = Disclosure.parseAsSalt(elements.get(0));
        String claimName = Disclosure.extractClaimName(elements);
        Object claimValue = Disclosure.extractClaimValue(elements);
        if (claimName != null && SDUtility.isReservedKey(claimName)) {
            throw new IllegalArgumentException(String.format("The claim name ('%s') is a reserved key.", claimName));
        }
        return new Disclosure(salt, claimName, claimValue, json, disclosure);
    }

    private static List<?> parseAsDisclosureElements(String json) {
        List elements = SDUtility.fromJson(json, List.class);
        if (elements == null || elements.size() != 2 && elements.size() != 3) {
            throw new IllegalArgumentException("Not a JSON array having 2 or 3 elements.");
        }
        return elements;
    }

    private static String parseAsSalt(Object element) {
        if (!(element instanceof String)) {
            throw new IllegalArgumentException("The first element (salt) is not a string.");
        }
        return (String)element;
    }

    private static String extractClaimName(List<?> list) {
        if (list.size() == 2) {
            return null;
        }
        Object value = list.get(1);
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("The second element (claim name) is not a string.");
        }
        return (String)value;
    }

    private static Object extractClaimValue(List<?> list) {
        return list.get(list.size() - 1);
    }

    private static String generateSalt() {
        return SDUtility.toBase64url(SDUtility.generateRandomBytes(16));
    }
}

