/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.Disclosure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SDJWT {
    private static final String DELIMITER = "~";
    private final String credentialJwt;
    private final List<Disclosure> disclosures;
    private final String bindingJwt;
    private final String serialized;

    public SDJWT(String credentialJwt, Collection<Disclosure> disclosures) {
        this(credentialJwt, disclosures, null);
    }

    public SDJWT(String credentialJwt, Collection<Disclosure> disclosures, String bindingJwt) {
        this.credentialJwt = credentialJwt;
        this.disclosures = disclosures == null ? Collections.unmodifiableList(Collections.emptyList()) : disclosures.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        this.bindingJwt = bindingJwt;
        this.serialized = SDJWT.serialize(credentialJwt, this.disclosures, bindingJwt);
    }

    public String toString() {
        return this.serialized;
    }

    public String getCredentialJwt() {
        return this.credentialJwt;
    }

    public List<Disclosure> getDisclosures() {
        return this.disclosures;
    }

    public String getBindingJwt() {
        return this.bindingJwt;
    }

    public static SDJWT parse(String input) {
        List<Disclosure> disclosures;
        if (input == null) {
            return null;
        }
        String[] elements = input.split(DELIMITER, -1);
        int lastIndex = elements.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (elements[i].length() != 0) continue;
            throw new IllegalArgumentException("The SD-JWT is malformed.");
        }
        if (elements.length < 2) {
            throw new IllegalArgumentException("The SD-JWT is malformed.");
        }
        String credentialJwt = elements[0];
        String bindingJwt = input.endsWith(DELIMITER) ? null : elements[lastIndex];
        try {
            disclosures = Arrays.asList(elements).subList(1, lastIndex).stream().map(Disclosure::parse).collect(Collectors.toList());
        }
        catch (Exception cause) {
            throw new IllegalArgumentException("Failed to parse disclosures.", cause);
        }
        return new SDJWT(credentialJwt, disclosures, bindingJwt);
    }

    private static String serialize(String credentialJwt, List<Disclosure> disclosures, String bindingJwt) {
        Stream<String> stream = Stream.concat(Stream.of(credentialJwt), disclosures.stream().map(Disclosure::getDisclosure));
        stream = Stream.concat(stream, Stream.of(bindingJwt != null ? bindingJwt : ""));
        return stream.collect(Collectors.joining(DELIMITER));
    }
}

