/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.Disclosure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SDObjectDecoder {
    public Map<String, Object> decode(Map<String, Object> encodedMap, Collection<Disclosure> disclosures) {
        if (encodedMap == null) {
            return null;
        }
        String hashAlgorithm = SDObjectDecoder.determineHashAlgorithm(encodedMap);
        Map<String, Disclosure> digestMap = SDObjectDecoder.createDigestMap(hashAlgorithm, disclosures);
        return this.decodeMap(digestMap, encodedMap);
    }

    public List<Object> decode(List<?> encodedList, Collection<Disclosure> disclosures) {
        return this.decode(encodedList, disclosures, "sha-256");
    }

    public List<Object> decode(List<?> encodedList, Collection<Disclosure> disclosures, String hashAlgorithm) {
        if (encodedList == null) {
            return null;
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = "sha-256";
        }
        Map<String, Disclosure> digestMap = SDObjectDecoder.createDigestMap(hashAlgorithm, disclosures);
        return this.decodeList(digestMap, encodedList);
    }

    private static String determineHashAlgorithm(Map<String, Object> encodedMap) {
        if (!encodedMap.containsKey("_sd_alg")) {
            return "sha-256";
        }
        Object alg = encodedMap.get("_sd_alg");
        if (!(alg instanceof String)) {
            throw new IllegalArgumentException("The value of '_sd_alg' is not a string.");
        }
        return (String)alg;
    }

    private static Map<String, Disclosure> createDigestMap(String hashAlgorithm, Collection<Disclosure> disclosures) {
        LinkedHashMap<String, Disclosure> map = new LinkedHashMap<String, Disclosure>();
        if (disclosures == null) {
            return map;
        }
        for (Disclosure disclosure : disclosures) {
            if (disclosure == null) continue;
            String key = disclosure.digest(hashAlgorithm);
            map.put(key, disclosure);
        }
        return map;
    }

    private Map<String, Object> decodeMap(Map<String, Disclosure> digestMap, Map<String, Object> encodedMap) {
        LinkedHashMap<String, Object> decodedMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : encodedMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.decodeMapEntry(digestMap, key, value, decodedMap);
        }
        return decodedMap;
    }

    private void decodeMapEntry(Map<String, Disclosure> digestMap, String key, Object value, Map<String, Object> decodedMap) {
        if ("_sd_alg".equals(key)) {
            return;
        }
        if ("_sd".equals(key)) {
            this.decodeSD(digestMap, value, decodedMap);
            return;
        }
        if (value instanceof Map) {
            value = this.decodeMap(digestMap, (Map)value);
        } else if (value instanceof List) {
            value = this.decodeList(digestMap, (List)value);
        }
        decodedMap.put(key, value);
    }

    private void decodeSD(Map<String, Disclosure> digestMap, Object sd, Map<String, Object> decodedMap) {
        if (sd == null) {
            return;
        }
        if (!(sd instanceof List)) {
            throw new IllegalArgumentException("The value of '_sd' is not an array.");
        }
        for (Object element : (List)sd) {
            if (element == null) continue;
            if (!(element instanceof String)) {
                throw new IllegalArgumentException("An element in the '_sd' array is not a string.");
            }
            String digest = (String)element;
            this.decodeSDElement(digestMap, digest, decodedMap);
        }
    }

    private void decodeSDElement(Map<String, Disclosure> digestMap, String digest, Map<String, Object> decodedMap) {
        Disclosure disclosure = digestMap.get(digest);
        if (disclosure == null) {
            return;
        }
        String claimName = disclosure.getClaimName();
        Object claimValue = disclosure.getClaimValue();
        if (claimName == null) {
            throw new IllegalArgumentException("The digest of a disclosure for an array element is found in the '_sd' array.");
        }
        decodedMap.put(claimName, claimValue);
    }

    private List<Object> decodeList(Map<String, Disclosure> digestMap, List<?> encodedList) {
        ArrayList<Object> decodedList = new ArrayList<Object>();
        for (Object element : encodedList) {
            this.decodeListElement(digestMap, element, decodedList);
        }
        return decodedList;
    }

    private void decodeListElement(Map<String, Disclosure> digestMap, Object element, List<Object> decodedList) {
        if (element instanceof Map) {
            Map map = (Map)element;
            if (map.containsKey("...")) {
                this.decodeListElementMap(digestMap, map, decodedList);
                return;
            }
            element = this.decodeMap(digestMap, map);
        } else if (element instanceof List) {
            element = this.decodeList(digestMap, (List)element);
        }
        decodedList.add(element);
    }

    private void decodeListElementMap(Map<String, Disclosure> digestMap, Map<String, Object> element, List<Object> decodedList) {
        if (element.size() != 1) {
            throw new IllegalArgumentException("An object containing the three-dot key ('...') must not contain other keys.");
        }
        Object dots = element.get("...");
        if (dots == null) {
            return;
        }
        if (!(dots instanceof String)) {
            throw new IllegalArgumentException("The value of the three-dot key ('...') is not a string.");
        }
        String digest = (String)dots;
        this.decodeDots(digestMap, digest, decodedList);
    }

    private void decodeDots(Map<String, Disclosure> digestMap, String digest, List<Object> decodedList) {
        Disclosure disclosure = digestMap.get(digest);
        if (disclosure == null) {
            return;
        }
        if (disclosure.getClaimName() != null) {
            throw new IllegalArgumentException("The digest of a disclosure for an object property is specified by '...'.");
        }
        decodedList.add(disclosure.getClaimValue());
    }
}

