/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.junit;

import com.automation.remarks.video.RecorderFactory;
import com.automation.remarks.video.RecordingUtils;
import com.automation.remarks.video.annotations.Video;
import com.automation.remarks.video.enums.RecorderType;
import com.automation.remarks.video.recorder.IVideoRecorder;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.io.File;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class VideoRule
extends TestWatcher {
    private IVideoRecorder recorder;

    protected void starting(Description description) {
        if (this.videoDisabled(description)) {
            return;
        }
        this.recorder = RecorderFactory.getRecorder((RecorderType)VideoRecorder.conf().recorderType());
        this.recorder.start();
    }

    protected void succeeded(Description description) {
        String fileName = this.getFileName(description);
        File video = this.stopRecording(fileName);
        RecordingUtils.doVideoProcessing((boolean)true, (File)video);
    }

    protected void failed(Throwable e, Description description) {
        if (this.videoDisabled(description)) {
            return;
        }
        String fileName = this.getFileName(description);
        File file = this.stopRecording(fileName);
        RecordingUtils.doVideoProcessing((boolean)false, (File)file);
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        this.failed((Throwable)e, description);
    }

    private boolean videoDisabled(Description description) {
        return !RecordingUtils.videoEnabled((Video)((Video)description.getAnnotation(Video.class)));
    }

    protected String getFileName(Description description) {
        String methodName = description.getMethodName();
        Video video = (Video)description.getAnnotation(Video.class);
        return RecordingUtils.getVideoFileName((Video)video, (String)methodName);
    }

    private File stopRecording(String filename) {
        if (this.recorder != null) {
            return this.recorder.stopAndSave(filename);
        }
        return null;
    }
}

