/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.junit5;

import com.automation.remarks.junit5.Video;
import com.automation.remarks.video.RecorderFactory;
import com.automation.remarks.video.RecordingUtils;
import com.automation.remarks.video.enums.RecorderType;
import com.automation.remarks.video.recorder.IVideoRecorder;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class VideoExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private IVideoRecorder recorder;

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (this.videoDisabled((Method)context.getTestMethod().get())) {
            return;
        }
        this.recorder = RecorderFactory.getRecorder((RecorderType)VideoRecorder.conf().recorderType());
        this.recorder.start();
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        if (this.videoDisabled((Method)context.getTestMethod().get())) {
            return;
        }
        String fileName = this.getFileName((Method)context.getTestMethod().get());
        File video = this.stopRecording(fileName);
        if (context.getExecutionException().isPresent()) {
            RecordingUtils.doVideoProcessing((boolean)false, (File)video);
        } else {
            RecordingUtils.doVideoProcessing((boolean)true, (File)video);
        }
    }

    private boolean videoDisabled(Method testMethod) {
        Optional video = AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, com.automation.remarks.video.annotations.Video.class);
        return video.map(v -> !RecordingUtils.videoEnabled((com.automation.remarks.video.annotations.Video)v)).orElseGet(() -> true);
    }

    private String getFileName(Method testMethod) {
        String methodName = testMethod.getName();
        Video video = testMethod.getAnnotation(Video.class);
        return VideoExtension.getVideoFileName(video, methodName);
    }

    private static String getVideoFileName(Video annotation, String methodName) {
        if (annotation == null) {
            return methodName;
        }
        String name = annotation.name();
        return name.length() > 1 ? name : methodName;
    }

    private File stopRecording(String filename) {
        if (this.recorder != null) {
            return this.recorder.stopAndSave(filename);
        }
        return null;
    }
}

