/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.testng;

import com.automation.remarks.testng.RemoteVideoClient;
import com.automation.remarks.testng.utils.ListenerUtils;
import com.automation.remarks.testng.utils.MethodUtils;
import com.automation.remarks.video.RecordingUtils;
import com.automation.remarks.video.annotations.Video;
import com.automation.remarks.video.recorder.VideoRecorder;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class RemoteVideoListener
implements ITestListener {
    private RemoteVideoClient videoClient;

    public void onStart(ITestContext context) {
    }

    public void onTestStart(ITestResult result) {
        String nodeUrl = VideoRecorder.conf().remoteUrl();
        this.videoClient = new RemoteVideoClient(nodeUrl);
        Video video = MethodUtils.getVideoAnnotation(result);
        if (RecordingUtils.videoEnabled((Video)video)) {
            this.videoClient.videoStart();
        }
    }

    public void onTestSuccess(ITestResult result) {
        String testName = ListenerUtils.getFileName(result);
        Video video = MethodUtils.getVideoAnnotation(result);
        if (RecordingUtils.videoEnabled((Video)video)) {
            this.videoClient.videoStop(testName, true);
        }
    }

    public void onTestFailure(ITestResult result) {
        String testName = ListenerUtils.getFileName(result);
        Video video = MethodUtils.getVideoAnnotation(result);
        if (RecordingUtils.videoEnabled((Video)video)) {
            this.videoClient.videoStop(testName, false);
        }
    }

    public void onTestSkipped(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onFinish(ITestContext context) {
    }
}

