/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.testng;

import com.automation.remarks.testng.IVideoRecordClient;
import com.automation.remarks.testng.utils.RestUtils;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class RemoteVideoRecordClient
implements IVideoRecordClient {
    private String servletUrl;

    public RemoteVideoRecordClient(String nodeUrl) {
        String servletPath = "/extra/Video";
        this.servletUrl = nodeUrl + servletPath;
    }

    @Override
    public void start() {
        String folderUrl = this.encodeFilePath(new File(VideoRecorder.conf().folder()));
        String url = this.servletUrl + "/start?&folder=" + folderUrl;
        RestUtils.sendRecordingRequest(url);
    }

    @Override
    public String stopAndSave(String testName, boolean isSuccess) {
        String url = this.servletUrl + "/stop?result=" + isSuccess + "&name=" + testName;
        return this.getFilePathFromResponse(url);
    }

    private String getFilePathFromResponse(String url) {
        return RestUtils.sendRecordingRequest(url).replace("recording stopped ", "");
    }

    private String encodeFilePath(File file) {
        URL videoFolder = null;
        try {
            videoFolder = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return videoFolder != null ? videoFolder.toString().replace("file:", "") : null;
    }
}

