/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.testng;

import com.automation.remarks.testng.IVideoRecordClient;
import com.automation.remarks.testng.LocalVideoRecordClient;
import com.automation.remarks.testng.RemoteVideoRecordClient;
import com.automation.remarks.testng.TestNgListener;
import com.automation.remarks.testng.utils.ListenerUtils;
import com.automation.remarks.testng.utils.MethodUtils;
import com.automation.remarks.video.RecordingUtils;
import com.automation.remarks.video.annotations.Video;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.util.List;
import org.testng.ITestResult;

public class UniversalVideoListener
extends TestNgListener {
    private IVideoRecordClient videoRecordClient;

    @Override
    public void onTestStart(ITestResult result) {
        if (this.videoDisabled(result) || this.shouldNotIntercept(result)) {
            return;
        }
        if (VideoRecorder.conf().isRemote().booleanValue()) {
            String nodeUrl = VideoRecorder.conf().remoteUrl();
            this.videoRecordClient = new RemoteVideoRecordClient(nodeUrl);
        } else {
            this.videoRecordClient = new LocalVideoRecordClient();
        }
        this.videoRecordClient.start();
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        if (this.videoDisabled(result) || this.shouldNotIntercept(result)) {
            return;
        }
        String fileName = ListenerUtils.getFileName(result);
        this.videoRecordClient.stopAndSave(fileName, true);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        if (this.videoDisabled(result) || this.shouldNotIntercept(result)) {
            return;
        }
        String fileName = ListenerUtils.getFileName(result);
        this.videoRecordClient.stopAndSave(fileName, false);
    }

    private boolean videoDisabled(ITestResult result) {
        return !RecordingUtils.videoEnabled((Video)MethodUtils.getVideoAnnotation(result));
    }

    public boolean shouldNotIntercept(ITestResult result) {
        List listeners = result.getTestContext().getCurrentXmlTest().getSuite().getListeners();
        return !listeners.contains(this.getClass().getName()) && !this.shouldIntercept(result.getTestClass().getRealClass(), this.getClass());
    }
}

