/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.testng;

import com.automation.remarks.testng.TestNgListener;
import com.automation.remarks.testng.utils.ListenerUtils;
import com.automation.remarks.testng.utils.MethodUtils;
import com.automation.remarks.video.RecorderFactory;
import com.automation.remarks.video.RecordingUtils;
import com.automation.remarks.video.annotations.Video;
import com.automation.remarks.video.enums.RecorderType;
import com.automation.remarks.video.recorder.IVideoRecorder;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.io.File;
import java.util.List;
import org.testng.ITestResult;

public class VideoListener
extends TestNgListener {
    private IVideoRecorder recorder;

    @Override
    public void onTestStart(ITestResult result) {
        if (this.videoDisabled(result) || !this.shouldIntercept(result)) {
            return;
        }
        this.recorder = RecorderFactory.getRecorder((RecorderType)VideoRecorder.conf().recorderType());
        this.recorder.start();
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        String fileName = ListenerUtils.getFileName(result);
        File video = this.stopRecording(fileName);
        RecordingUtils.doVideoProcessing((boolean)true, (File)video);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        if (this.videoDisabled(result) || !this.shouldIntercept(result)) {
            return;
        }
        String fileName = ListenerUtils.getFileName(result);
        File file = this.stopRecording(fileName);
        RecordingUtils.doVideoProcessing((boolean)false, (File)file);
    }

    private boolean videoDisabled(ITestResult result) {
        return !RecordingUtils.videoEnabled((Video)MethodUtils.getVideoAnnotation(result));
    }

    public boolean shouldIntercept(ITestResult result) {
        List listeners = result.getTestContext().getCurrentXmlTest().getSuite().getListeners();
        return listeners.contains(this.getClass().getName()) || this.shouldIntercept(result.getTestClass().getRealClass(), this.getClass());
    }

    private File stopRecording(String filename) {
        if (this.recorder != null) {
            return this.recorder.stopAndSave(filename);
        }
        return null;
    }
}

