/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder;

import com.automation.remarks.video.exception.RecordingException;
import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.monte.media.Format;
import org.monte.media.Registry;
import org.monte.screenrecorder.ScreenRecorder;

public class GeneralScreenRecorder
extends ScreenRecorder {
    private String fileName;
    private LinkedList<File> createdFiles = new LinkedList();

    public GeneralScreenRecorder(GraphicsConfiguration cfg, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat, File folder, String fileName) throws IOException, AWTException {
        super(cfg, fileFormat, screenFormat, mouseFormat, audioFormat);
        this.fileName = fileName;
        this.setMovieFolder(folder);
    }

    @Override
    protected File createMovieFile(Format fileFormat) throws IOException {
        if (!this.movieFolder.exists()) {
            this.movieFolder.mkdirs();
        } else if (!this.movieFolder.isDirectory()) {
            throw new IOException("[" + this.movieFolder + "] is not a directory.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_dd_MM_HH_mm_ss");
        this.fileName = this.fileName + "_recording_" + dateFormat.format(new Date());
        File file = new File(this.movieFolder, this.fileName + "." + Registry.getInstance().getExtension(fileFormat));
        this.createdFiles.add(file);
        return file;
    }

    public LinkedList<File> getCreatedMovieFiles() {
        return this.createdFiles;
    }

    public void setMovieFolder(File movieFolder) {
        this.movieFolder = movieFolder;
    }

    @Override
    public void start() {
        try {
            super.start();
        }
        catch (IOException e) {
            throw new RecordingException(e);
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        catch (IOException e) {
            throw new RecordingException(e);
        }
    }
}

