/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder;

import com.automation.remarks.video.recorder.GeneralScreenRecorder;
import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.io.File;
import java.io.IOException;
import org.monte.media.Format;

public class GeneralScreenRecorderBuilder {
    private GraphicsConfiguration cfg;
    private Format fileFormat;
    private Format screenFormat;
    private Format mouseFormat;
    private Format audioFormat;
    private File folder;
    private String fileName;

    public static Builder builder() {
        return new GeneralScreenRecorderBuilder().new Builder();
    }

    public class Builder {
        public Builder setGraphicConfig(GraphicsConfiguration cfg) {
            GeneralScreenRecorderBuilder.this.cfg = cfg;
            return this;
        }

        public Builder setFileFormat(Format fileFormat) {
            GeneralScreenRecorderBuilder.this.fileFormat = fileFormat;
            return this;
        }

        public Builder setScreenFormat(Format screenFormat) {
            GeneralScreenRecorderBuilder.this.screenFormat = screenFormat;
            return this;
        }

        public Builder setMouseFormat(Format mouseFormat) {
            GeneralScreenRecorderBuilder.this.mouseFormat = mouseFormat;
            return this;
        }

        public Builder setAudioFormat(Format audioFormat) {
            GeneralScreenRecorderBuilder.this.audioFormat = audioFormat;
            return this;
        }

        public Builder setFolder(File folder) {
            GeneralScreenRecorderBuilder.this.folder = folder;
            return this;
        }

        public Builder setFileName(String fileName) {
            GeneralScreenRecorderBuilder.this.fileName = fileName;
            return this;
        }

        public GeneralScreenRecorder build() {
            try {
                return new GeneralScreenRecorder(GeneralScreenRecorderBuilder.this.cfg, GeneralScreenRecorderBuilder.this.fileFormat, GeneralScreenRecorderBuilder.this.screenFormat, GeneralScreenRecorderBuilder.this.mouseFormat, GeneralScreenRecorderBuilder.this.audioFormat, GeneralScreenRecorderBuilder.this.folder, GeneralScreenRecorderBuilder.this.fileName);
            }
            catch (AWTException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

