/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.recorder;

import com.automation.remarks.video.VideoConfiguration;
import com.automation.remarks.video.recorder.GeneralScreenRecorder;
import com.automation.remarks.video.recorder.GeneralScreenRecorderBuilder;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.LinkedList;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;

public class VideoRecorder {
    private String fileName;
    private GeneralScreenRecorder screenRecorder;
    private GraphicsConfiguration gc;
    private File folder;

    public VideoRecorder(String fileName) {
        this.fileName = fileName;
        this.folder = new File(VideoConfiguration.VIDEO_FOLDER);
        this.gc = this.getGraphicConfig();
        this.screenRecorder = this.getScreenRecorder();
    }

    public void start() {
        if (VideoRecorder.videoEnabled()) {
            this.screenRecorder.start();
        }
    }

    public LinkedList<File> stop() {
        if (VideoRecorder.videoEnabled()) {
            this.screenRecorder.stop();
        }
        return this.screenRecorder.getCreatedMovieFiles();
    }

    public static boolean videoEnabled() {
        try {
            return Boolean.valueOf(VideoConfiguration.VIDEO_ENABLED);
        }
        catch (Exception e) {
            return false;
        }
    }

    private GraphicsConfiguration getGraphicConfig() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private GeneralScreenRecorder getScreenRecorder() {
        Format fileFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"});
        Format screenFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "tscc", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, Rational.valueOf(15.0), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), FormatKeys.KeyFrameIntervalKey, 900});
        Format mouseFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, Rational.valueOf(30.0)});
        return GeneralScreenRecorderBuilder.builder().setGraphicConfig(this.gc).setFileFormat(fileFormat).setScreenFormat(screenFormat).setFolder(this.folder).setMouseFormat(mouseFormat).setFileName(this.fileName).build();
    }
}

