/*
 * Decompiled with CFR 0.152.
 */
package com.automation.remarks.video.testng;

import com.automation.remarks.video.annotations.Video;
import com.automation.remarks.video.recorder.VideoRecorder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public class VideoListener
implements IInvokedMethodListener {
    private VideoRecorder recorder;

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        boolean testMethod = method.isTestMethod();
        Video video = this.getVideoAnnotation(method);
        if (video == null || !testMethod || !video.enabled()) {
            return;
        }
        String fileName = this.getFileName(method, video);
        this.recorder = new VideoRecorder(fileName);
        this.recorder.start();
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.recorder != null) {
            LinkedList<File> recordings = this.recorder.stop();
            this.deleteRecordingOnSuccess(testResult, recordings);
        }
    }

    private void deleteRecordingOnSuccess(ITestResult testResult, LinkedList<File> recordings) {
        if (testResult.isSuccess()) {
            recordings.getFirst().delete();
        } else {
            System.err.println(recordings);
        }
    }

    public String getFileName(IInvokedMethod method, Video video) {
        String name = video.name();
        if (name.length() == 0) {
            name = method.getTestMethod().getMethodName();
        }
        return name;
    }

    private Video getVideoAnnotation(IInvokedMethod method) {
        Annotation[] declaredAnnotations;
        for (Annotation declaredAnnotation : declaredAnnotations = method.getTestMethod().getConstructorOrMethod().getMethod().getDeclaredAnnotations()) {
            if (!declaredAnnotation.annotationType().equals(Video.class)) continue;
            return (Video)declaredAnnotation;
        }
        return null;
    }
}

