/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceInformation {
    public static final String LOGTAG = "NosaraDeviceInformation";
    private final Context mContext;
    private final Boolean mHasNFC;
    private final Boolean mHasTelephony;
    private final DisplayMetrics mDisplayMetrics;
    private final String mAppName;
    private final String mAppVersionName;
    private final Integer mAppVersionCode;
    private final String mDeviceLanguage;
    private final JSONObject mImmutableDeviceInfoJSON;

    public DeviceInformation(Context context) {
        this.mContext = context;
        String mOs = "Android";
        String mOSVersion = Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE;
        String mManufacturer = Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER;
        String mBrand = Build.BRAND == null ? "UNKNOWN" : Build.BRAND;
        String mModel = Build.MODEL == null ? "UNKNOWN" : Build.MODEL;
        PackageManager packageManager = this.mContext.getPackageManager();
        String foundAppVersionName = null;
        Integer foundAppVersionCode = null;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
            foundAppVersionName = packageInfo.versionName;
            foundAppVersionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)LOGTAG, (String)"System information constructed with a context that apparently doesn't exist.");
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(this.mContext.getApplicationInfo().packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)LOGTAG, (String)"System information constructed with a context that apparently doesn't exist.");
        }
        this.mAppName = applicationInfo != null ? packageManager.getApplicationLabel(applicationInfo).toString() : "Unknown";
        this.mAppVersionName = foundAppVersionName;
        this.mAppVersionCode = foundAppVersionCode;
        this.mDeviceLanguage = Locale.getDefault().toString();
        Class<?> packageManagerClass = packageManager.getClass();
        Method hasSystemFeatureMethod = null;
        try {
            hasSystemFeatureMethod = packageManagerClass.getMethod("hasSystemFeature", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Boolean foundNFC = null;
        Boolean foundTelephony = null;
        if (null != hasSystemFeatureMethod) {
            try {
                foundNFC = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.nfc");
                foundTelephony = (Boolean)hasSystemFeatureMethod.invoke((Object)packageManager, "android.hardware.telephony");
            }
            catch (InvocationTargetException e) {
                Log.w((String)LOGTAG, (String)"System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
            }
            catch (IllegalAccessException e) {
                Log.w((String)LOGTAG, (String)"System version appeared to support PackageManager.hasSystemFeature, but we were unable to call it.");
            }
        }
        this.mHasNFC = foundNFC;
        this.mHasTelephony = foundTelephony;
        this.mDisplayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        display.getMetrics(this.mDisplayMetrics);
        this.mImmutableDeviceInfoJSON = new JSONObject();
        try {
            this.mImmutableDeviceInfoJSON.put("os", (Object)"Android");
            this.mImmutableDeviceInfoJSON.put("os_version", (Object)mOSVersion);
            this.mImmutableDeviceInfoJSON.put("manufacturer", (Object)mManufacturer);
            this.mImmutableDeviceInfoJSON.put("brand", (Object)mBrand);
            this.mImmutableDeviceInfoJSON.put("model", (Object)mModel);
            this.mImmutableDeviceInfoJSON.put("app_name", (Object)this.getAppName());
            this.mImmutableDeviceInfoJSON.put("app_version", (Object)this.getAppVersionName());
            this.mImmutableDeviceInfoJSON.put("app_version_code", (Object)Integer.toString(this.getAppVersionCode()));
            this.mImmutableDeviceInfoJSON.put("language", (Object)this.getDeviceLanguage());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing basic device info values in JSON object", (Throwable)e);
        }
        try {
            this.mImmutableDeviceInfoJSON.put("has_NFC", this.hasNFC());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing has_NFS value in JSON object", (Throwable)e);
        }
        try {
            this.mImmutableDeviceInfoJSON.put("has_telephony", this.hasTelephony());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing has_telephony value in JSON object", (Throwable)e);
        }
        try {
            DisplayMetrics dMetrics = this.getDisplayMetrics();
            this.mImmutableDeviceInfoJSON.put("display_density_dpi", dMetrics.densityDpi);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing display_density_dpi value in JSON object", (Throwable)e);
        }
        try {
            this.mImmutableDeviceInfoJSON.put("bluetooth_version", (Object)this.getBluetoothVersion());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing bluetooth info values in JSON object", (Throwable)e);
        }
    }

    public JSONObject getMutableDeviceInfo() {
        JSONObject mutableDeviceInfo = new JSONObject();
        try {
            mutableDeviceInfo.put("bluetooth_enabled", (Object)this.isBluetoothEnabled());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing bluetooth info values in JSON object", (Throwable)e);
        }
        try {
            mutableDeviceInfo.put("current_network_operator", (Object)this.getCurrentNetworkOperator());
            mutableDeviceInfo.put("phone_radio_type", (Object)this.getPhoneRadioType());
            mutableDeviceInfo.put("wifi_connected", (Object)this.isWifiConnected());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Exception writing network info values in JSON object", (Throwable)e);
        }
        return mutableDeviceInfo;
    }

    public JSONObject getImmutableDeviceInfo() {
        return this.mImmutableDeviceInfoJSON;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getAppVersionName() {
        return this.mAppVersionName;
    }

    public Integer getAppVersionCode() {
        return this.mAppVersionCode;
    }

    public boolean hasNFC() {
        return this.mHasNFC;
    }

    public boolean hasTelephony() {
        return this.mHasTelephony;
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    public String getPhoneRadioType() {
        String ret = null;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null != telephonyManager) {
            switch (telephonyManager.getPhoneType()) {
                case 0: {
                    ret = "none";
                    break;
                }
                case 1: {
                    ret = "gsm";
                    break;
                }
                case 2: {
                    ret = "cdma";
                    break;
                }
                case 3: {
                    ret = "sip";
                    break;
                }
                default: {
                    ret = null;
                }
            }
        }
        return ret;
    }

    public String getCurrentNetworkOperator() {
        String ret = null;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (null != telephonyManager) {
            ret = telephonyManager.getNetworkOperatorName();
        }
        return ret;
    }

    public Boolean isWifiConnected() {
        Boolean ret = null;
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
            ret = wifiInfo.isConnected();
        }
        return ret;
    }

    public Boolean isBluetoothEnabled() {
        BluetoothAdapter bluetoothAdapter;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        Boolean isBluetoothEnabled = null;
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.BLUETOOTH") && (bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) != null) {
            isBluetoothEnabled = bluetoothAdapter.isEnabled();
        }
        return isBluetoothEnabled;
    }

    public String getBluetoothVersion() {
        String bluetoothVersion = null;
        if (Build.VERSION.SDK_INT >= 8) {
            bluetoothVersion = "none";
            if (Build.VERSION.SDK_INT >= 18 && this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                bluetoothVersion = "ble";
            } else if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                bluetoothVersion = "classic";
            }
        }
        return bluetoothVersion;
    }

    public int getDeviceWidthPixels() {
        return this.getDisplayMetrics().widthPixels;
    }

    public int getDeviceHeightPixels() {
        return this.getDisplayMetrics().heightPixels;
    }

    public String getDeviceLanguage() {
        return this.mDeviceLanguage;
    }
}

