/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks;

import android.util.Log;
import com.automattic.android.tracks.Exceptions.EventNameException;
import com.automattic.android.tracks.MessageBuilder;
import com.automattic.android.tracks.StringUtils;
import com.automattic.android.tracks.TracksClient;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Event
implements Serializable {
    public static final String LOGTAG = "NosaraEvent";
    private static final String EVENT_NAME_REGEXP = "^(([a-z0-9]+)_){2}([a-z0-9_]+)$";
    private static final Pattern eventNameRegExpPattern = Pattern.compile("^(([a-z0-9]+)_){2}([a-z0-9_]+)$");
    private static final String PROPERTY_NAME_REGEXP = "^[a-z_][a-z0-9_]*$";
    private static final Pattern propertyNameRegExpPattern = Pattern.compile("^[a-z_][a-z0-9_]*$");
    private final String mEventName;
    private final String mUser;
    private final String mUserAgent;
    private final long mTimeStamp;
    private final TracksClient.NosaraUserType mUserType;
    private int mRetryCount = 0;
    private JSONObject mUserProperties;
    private JSONObject mDeviceInfo;
    private JSONObject mCustomEventProps;

    public Event(String mEventName, String userID, TracksClient.NosaraUserType uType, String userAgent, long timeStamp) throws EventNameException {
        this.checkEventName(mEventName);
        this.mEventName = mEventName;
        this.mUser = userID;
        this.mUserType = uType;
        this.mUserAgent = userAgent;
        this.mTimeStamp = timeStamp;
    }

    private void checkEventName(String name) throws EventNameException {
        if (name.equals("_aliasUser")) {
            return;
        }
        if (name.contains("-")) {
            String errorMessage = "Event name must not contains dashes.";
            throw new EventNameException(errorMessage);
        }
        if (StringUtils.containsWhiteSpace(name)) {
            throw new EventNameException("Event name must not contains whitespace.");
        }
        Matcher matcher = eventNameRegExpPattern.matcher(name);
        if (!matcher.matches()) {
            throw new EventNameException("Event name must match: ^(([a-z0-9]+)_){2}([a-z0-9_]+)$");
        }
    }

    public String getEventName() {
        return this.mEventName;
    }

    public String getUser() {
        return this.mUser;
    }

    public TracksClient.NosaraUserType getUserType() {
        return this.mUserType;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public void addRetryCount() {
        ++this.mRetryCount;
    }

    public void setUserProperties(JSONObject userProperties) {
        this.mUserProperties = userProperties;
    }

    public void setDeviceInfo(JSONObject deviceInfo) {
        this.mDeviceInfo = deviceInfo;
    }

    public JSONObject getUserProperties() {
        return this.mUserProperties;
    }

    public JSONObject getDeviceInfo() {
        return this.mDeviceInfo;
    }

    public JSONObject getCustomEventProperties() {
        return this.mCustomEventProps;
    }

    public boolean addCustomEventProperty(String key, Object value) {
        Matcher matcher;
        if (StringUtils.isBlank(key)) {
            Log.e((String)LOGTAG, (String)"Cannot add a property that has an empty key to the event");
            return false;
        }
        if (this.mCustomEventProps == null) {
            this.mCustomEventProps = new JSONObject();
        }
        if (!key.toLowerCase().equals(key)) {
            Log.w((String)LOGTAG, (String)("Properties should have lowercase name: " + key));
        }
        if (key.startsWith("_")) {
            Log.e((String)LOGTAG, (String)("Cannot add the property: " + key + " to the event. Leading underscores are reserved."));
            return false;
        }
        if (MessageBuilder.isReservedKeyword(key)) {
            Log.e((String)LOGTAG, (String)("Cannot add the property: " + key + " to the event. It's a reserved keyword."));
            return false;
        }
        if (!(this.getEventName().equals("_aliasUser") && key.equals("anonId") || (matcher = propertyNameRegExpPattern.matcher(key)).matches())) {
            Log.e((String)LOGTAG, (String)("Cannot add the property: " + key + " to the event. Property name must match: " + PROPERTY_NAME_REGEXP));
            return false;
        }
        try {
            String valueString = value != null ? String.valueOf(value) : "";
            this.mCustomEventProps.put(key, (Object)valueString);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Cannot add the property to the event");
            return false;
        }
        return true;
    }

    public void setCustomProperties(JSONObject customProperties) {
        this.mCustomEventProps = customProperties;
    }
}

