/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks;

import android.content.Context;
import android.util.Log;
import com.automattic.android.tracks.DeviceInformation;
import com.automattic.android.tracks.Event;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class MessageBuilder {
    private static final String USER_INFO_PREFIX = "user_info_";
    private static final String DEVICE_INFO_PREFIX = "device_info_";
    private static final String EVENT_NAME_KEY = "_en";
    private static final String USER_AGENT_NAME_KEY = "_via_ua";
    private static final String EVENT_TIMESTAMP_KEY = "_ts";
    private static final String REQUEST_TIMESTAMP_KEY = "_rt";
    private static final String USER_TYPE_KEY = "_ut";
    private static final String USER_TYPE_ANON = "anon";
    private static final String USER_TYPE_WPCOM = "wpcom:user_id";
    private static final String USER_TYPE_SIMPLENOTE = "simplenote:user_id";
    private static final String USER_ID_KEY = "_ui";
    private static final String USER_LANG_KEY = "_lg";
    private static final String USER_LOGIN_NAME_KEY = "_ul";
    private static final String DEVICE_HEIGHT_PIXELS_KEY = "_ht";
    private static final String DEVICE_WIDTH_PIXELS_KEY = "_wd";
    public static final String ALIAS_USER_EVENT_NAME = "_aliasUser";
    public static final String ALIAS_USER_ANONID_PROP_NAME = "anonId";

    MessageBuilder() {
    }

    public static synchronized boolean isReservedKeyword(String keyToTest) {
        String keyToTestLowercase = keyToTest.toLowerCase();
        if (keyToTestLowercase.equals(EVENT_NAME_KEY) || keyToTestLowercase.equals(USER_AGENT_NAME_KEY) || keyToTestLowercase.equals(EVENT_TIMESTAMP_KEY) || keyToTestLowercase.equals(REQUEST_TIMESTAMP_KEY) || keyToTestLowercase.equals(USER_TYPE_KEY) || keyToTestLowercase.equals(USER_ID_KEY) || keyToTestLowercase.equals(DEVICE_WIDTH_PIXELS_KEY) || keyToTestLowercase.equals(DEVICE_HEIGHT_PIXELS_KEY) || keyToTestLowercase.equals(USER_LANG_KEY) || keyToTestLowercase.equals(USER_LOGIN_NAME_KEY)) {
            return true;
        }
        return keyToTestLowercase.startsWith(USER_INFO_PREFIX) || keyToTestLowercase.startsWith(DEVICE_INFO_PREFIX);
    }

    public static synchronized JSONObject createRequestCommonPropsJSONObject(Context ctx, DeviceInformation deviceInformation, JSONObject userProperties, String userAgent) {
        JSONObject commonProps = new JSONObject();
        try {
            commonProps.put(USER_AGENT_NAME_KEY, (Object)userAgent);
        }
        catch (JSONException e) {
            Log.e((String)"NosaraClient", (String)"Cannot add the _via_ua property to request commons.");
        }
        try {
            commonProps.put(DEVICE_WIDTH_PIXELS_KEY, deviceInformation.getDeviceWidthPixels());
            commonProps.put(DEVICE_HEIGHT_PIXELS_KEY, deviceInformation.getDeviceHeightPixels());
        }
        catch (JSONException e) {
            Log.e((String)"NosaraClient", (String)"Cannot add the device width/height properties to request commons.");
        }
        try {
            commonProps.put(USER_LANG_KEY, (Object)ctx.getResources().getConfiguration().locale.toString());
        }
        catch (JSONException e) {
            Log.e((String)"NosaraClient", (String)"Cannot add the device language property to request commons.");
        }
        MessageBuilder.unfolderProperties(deviceInformation.getImmutableDeviceInfo(), DEVICE_INFO_PREFIX, commonProps);
        MessageBuilder.unfolderProperties(deviceInformation.getMutableDeviceInfo(), DEVICE_INFO_PREFIX, commonProps);
        MessageBuilder.unfolderProperties(userProperties, USER_INFO_PREFIX, commonProps);
        try {
            commonProps.put(REQUEST_TIMESTAMP_KEY, System.currentTimeMillis());
        }
        catch (JSONException e) {
            Log.e((String)"NosaraClient", (String)"Cannot add the _rt property to the request. Current batch request will be discarded on the server side", (Throwable)e);
        }
        return commonProps;
    }

    public static synchronized JSONObject createEventJSONObject(Event event, JSONObject commonProps) {
        try {
            JSONObject eventJSON = new JSONObject();
            eventJSON.put(EVENT_NAME_KEY, (Object)event.getEventName());
            if (!commonProps.has(USER_AGENT_NAME_KEY) || !commonProps.getString(USER_AGENT_NAME_KEY).equals(event.getUserAgent())) {
                eventJSON.put(USER_AGENT_NAME_KEY, (Object)event.getUserAgent());
            }
            eventJSON.put(EVENT_TIMESTAMP_KEY, event.getTimeStamp());
            switch (event.getUserType()) {
                case ANON: {
                    eventJSON.put(USER_ID_KEY, (Object)event.getUser());
                    eventJSON.put(USER_TYPE_KEY, (Object)USER_TYPE_ANON);
                    break;
                }
                case WPCOM: {
                    eventJSON.put(USER_LOGIN_NAME_KEY, (Object)event.getUser());
                    eventJSON.put(USER_TYPE_KEY, (Object)USER_TYPE_WPCOM);
                    break;
                }
                case SIMPLENOTE: {
                    eventJSON.put(USER_LOGIN_NAME_KEY, (Object)event.getUser());
                    eventJSON.put(USER_TYPE_KEY, (Object)USER_TYPE_SIMPLENOTE);
                }
            }
            MessageBuilder.unfolderPropertiesNotAvailableInCommon(event.getUserProperties(), USER_INFO_PREFIX, eventJSON, commonProps);
            MessageBuilder.unfolderPropertiesNotAvailableInCommon(event.getDeviceInfo(), DEVICE_INFO_PREFIX, eventJSON, commonProps);
            MessageBuilder.unfolderProperties(event.getCustomEventProperties(), "", eventJSON);
            if (event.getEventName().equals(ALIAS_USER_EVENT_NAME)) {
                String anonID = eventJSON.getString(ALIAS_USER_ANONID_PROP_NAME.toLowerCase());
                eventJSON.put(ALIAS_USER_ANONID_PROP_NAME, (Object)anonID);
                eventJSON.remove(ALIAS_USER_ANONID_PROP_NAME.toLowerCase());
            }
            return eventJSON;
        }
        catch (JSONException err) {
            Log.e((String)"NosaraClient", (String)"Cannot write the JSON representation of the event object", (Throwable)err);
            return null;
        }
    }

    private static void unfolderPropertiesNotAvailableInCommon(JSONObject objectToFlatten, String flattenPrefix, JSONObject targetJSONObject, JSONObject commonProps) {
        if (objectToFlatten == null || targetJSONObject == null) {
            return;
        }
        if (flattenPrefix == null) {
            Log.w((String)"NosaraClient", (String)" Unfolding props with an empty key. Make sure the keys are unique!");
            flattenPrefix = "";
        }
        Iterator iter = objectToFlatten.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String flattenKey = String.valueOf(flattenPrefix + key).toLowerCase();
            try {
                Object valueInCommons;
                Object value = objectToFlatten.get(key);
                String valueString = value != null ? String.valueOf(value) : "";
                String valueStringInCommons = null;
                if (commonProps != null && commonProps.has(flattenKey) && (valueInCommons = commonProps.get(flattenKey)) != null) {
                    valueStringInCommons = String.valueOf(valueInCommons);
                }
                if (valueStringInCommons != null && valueStringInCommons.equals(valueString)) continue;
                targetJSONObject.put(flattenKey, (Object)valueString);
            }
            catch (JSONException e) {
                Log.e((String)"NosaraClient", (String)"Cannot write the flatten JSON representation of the JSON object", (Throwable)e);
            }
        }
    }

    private static void unfolderProperties(JSONObject objectToFlatten, String flattenPrefix, JSONObject targetJSONObject) {
        MessageBuilder.unfolderPropertiesNotAvailableInCommon(objectToFlatten, flattenPrefix, targetJSONObject, null);
    }
}

