/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;

public class NetworkUtils {
    public static final int TYPE_UNKNOWN = -1;

    private static NetworkInfo getActiveNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return null;
        }
        return cm.getActiveNetworkInfo();
    }

    private static int getActiveNetworkType(Context context) {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo(context);
        if (info == null || !info.isConnected()) {
            return -1;
        }
        return info.getType();
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo(context);
        return info != null && info.isConnected();
    }

    public static boolean isWiFiConnected(Context context) {
        return NetworkUtils.getActiveNetworkType(context) == 1;
    }

    @TargetApi(value=17)
    public static boolean isAirplaneModeOn(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
        }
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }
}

