/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.util.Log;
import com.automattic.android.tracks.DeviceInformation;
import com.automattic.android.tracks.Event;
import com.automattic.android.tracks.Exceptions.EventNameException;
import com.automattic.android.tracks.MessageBuilder;
import com.automattic.android.tracks.NetworkUtils;
import com.automattic.android.tracks.datasets.EventTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TracksClient {
    public static final String LOGTAG = "NosaraClient";
    public static final String LIB_VERSION = "1.1.0";
    protected static final String DEFAULT_USER_AGENT = "Nosara Client for Android/1.1.0";
    protected static final String NOSARA_REST_API_ENDPOINT_URL_V1_1 = "https://public-api.wordpress.com/rest/v1.1/";
    protected static final int DEFAULT_EVENTS_QUEUE_THRESHOLD = 9;
    protected static final int DEFAULT_EVENTS_QUEUE_TIMER_MS = 30000;
    public static final int REST_TIMEOUT_MS = 30000;
    static final String PROTOCOL_CHARSET = "utf-8";
    static final String PROTOCOL_CONTENT_TYPE = String.format("application/json; charset=%s", "utf-8");
    private final Context mContext;
    private String mUserAgent = "Nosara Client for Android/1.1.0";
    private String mRestApiEndpointURL;
    private final String mTracksRestEndpointURL;
    private DeviceInformation deviceInformation;
    private JSONObject mUserProperties = new JSONObject();
    private final LinkedList<Event> mInsertEventsQueue = new LinkedList();
    private static final Object mDbLock = new Object();
    private final LinkedList<NetworkRequestObject> mNetworkQueue = new LinkedList();
    private boolean mPendingFlush = false;
    private static long WAIT_PERIOD_NETWORK_CONNECTION = 120000L;
    private long mLastNetworkErrorTimestamp = 0L;
    Handler mHandler = new Handler();
    private Runnable mEventsCountdownRunnable = new Runnable(){

        @Override
        public void run() {
            TracksClient.this.flush();
        }
    };

    public static TracksClient getClient(Context ctx) {
        if (null == ctx || !TracksClient.checkBasicConfiguration(ctx)) {
            return null;
        }
        return new TracksClient(ctx);
    }

    private TracksClient(Context ctx) {
        this.mContext = ctx;
        this.mRestApiEndpointURL = NOSARA_REST_API_ENDPOINT_URL_V1_1;
        this.mTracksRestEndpointURL = this.getAbsoluteURL("tracks/record");
        this.deviceInformation = new DeviceInformation(ctx);
        Thread bufferCopyThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedList shadowCopyEventList = new LinkedList();
                while (true) {
                    Object object = TracksClient.this.mInsertEventsQueue;
                    synchronized (object) {
                        try {
                            if (TracksClient.this.mInsertEventsQueue.size() == 0) {
                                TracksClient.this.mInsertEventsQueue.wait();
                            }
                            shadowCopyEventList.addAll(TracksClient.this.mInsertEventsQueue);
                            TracksClient.this.mInsertEventsQueue.clear();
                        }
                        catch (InterruptedException err) {
                            Log.e((String)TracksClient.LOGTAG, (String)"Something went wrong while waiting on the input queue of events", (Throwable)err);
                        }
                    }
                    if (shadowCopyEventList.size() <= 0) continue;
                    object = mDbLock;
                    synchronized (object) {
                        for (Event currentEvent : shadowCopyEventList) {
                            EventTable.insertEvent(TracksClient.this.mContext, currentEvent);
                        }
                        mDbLock.notifyAll();
                    }
                    shadowCopyEventList.clear();
                }
            }
        });
        bufferCopyThread.setPriority(1);
        bufferCopyThread.start();
        Thread sendToWireThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    NetworkRequestObject req = null;
                    Object object = mDbLock;
                    synchronized (object) {
                        block14: {
                            try {
                                boolean shouldWait;
                                TracksClient.this.mHandler.removeCallbacks(TracksClient.this.mEventsCountdownRunnable);
                                boolean bl = shouldWait = TracksClient.this.mLastNetworkErrorTimestamp > 0L && Math.abs(System.currentTimeMillis() - TracksClient.this.mLastNetworkErrorTimestamp) < WAIT_PERIOD_NETWORK_CONNECTION;
                                if ((TracksClient.this.mPendingFlush || !shouldWait && EventTable.getEventsCount(TracksClient.this.mContext) > 9) && NetworkUtils.isNetworkAvailable(TracksClient.this.mContext)) {
                                    TracksClient.this.mPendingFlush = false;
                                    try {
                                        JSONArray events = new JSONArray();
                                        LinkedList<Event> eventsList = EventTable.getAndDeleteEvents(TracksClient.this.mContext, 0);
                                        if (eventsList != null && eventsList.size() > 0) {
                                            JSONObject commonProps = MessageBuilder.createRequestCommonPropsJSONObject(TracksClient.this.mContext, TracksClient.this.deviceInformation, TracksClient.this.mUserProperties, TracksClient.this.getUserAgent());
                                            for (Event singleEvent : eventsList) {
                                                JSONObject singleEventJSON = MessageBuilder.createEventJSONObject(singleEvent, commonProps);
                                                if (singleEventJSON == null) continue;
                                                events.put((Object)singleEventJSON);
                                            }
                                            JSONObject requestJSONObject = new JSONObject();
                                            requestJSONObject.put("events", (Object)events);
                                            requestJSONObject.put("commonProps", (Object)commonProps);
                                            req = new NetworkRequestObject();
                                            req.requestObj = requestJSONObject;
                                            req.src = eventsList;
                                        }
                                        break block14;
                                    }
                                    catch (JSONException err) {
                                        Log.e((String)TracksClient.LOGTAG, (String)"Exception creating the request JSON object", (Throwable)err);
                                    }
                                    break block14;
                                }
                                TracksClient.this.mHandler.postDelayed(TracksClient.this.mEventsCountdownRunnable, 30000L);
                                mDbLock.wait();
                            }
                            catch (InterruptedException err) {
                                Log.e((String)TracksClient.LOGTAG, (String)"Something went wrong while waiting on the database lock", (Throwable)err);
                            }
                        }
                    }
                    if (req == null) continue;
                    object = TracksClient.this.mNetworkQueue;
                    synchronized (object) {
                        TracksClient.this.mNetworkQueue.add(req);
                        TracksClient.this.mNetworkQueue.notifyAll();
                    }
                }
            }
        });
        sendToWireThread.setPriority(1);
        sendToWireThread.start();
        Thread networkThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) lbl-1000:
                // 9 sources

                {
                    currentRequest = null;
                    var2_3 = TracksClient.access$1000(TracksClient.this);
                    synchronized (var2_3) {
                        try {
                            while (TracksClient.access$1000(TracksClient.this).size() == 0) {
                                TracksClient.access$1000(TracksClient.this).wait();
                            }
                            currentRequest = (NetworkRequestObject)TracksClient.access$1000(TracksClient.this).removeFirst();
                        }
                        catch (InterruptedException err) {
                            Log.e((String)"NosaraClient", (String)"Something went wrong while waiting on the network queue", (Throwable)err);
                        }
                    }
                    isErrorResponse = false;
                    if (NetworkUtils.isNetworkAvailable(TracksClient.access$200(TracksClient.this))) {
                        conn = null;
                        try {
                            requestURL = new URL(TracksClient.access$1100(TracksClient.this));
                            conn = (HttpURLConnection)requestURL.openConnection();
                            conn.setRequestProperty("Content-Type", TracksClient.PROTOCOL_CONTENT_TYPE);
                            conn.setReadTimeout(30000);
                            conn.setConnectTimeout(30000);
                            conn.setUseCaches(false);
                            conn.setRequestProperty("Connection", "close");
                            conn.setRequestProperty("User-Agent", TracksClient.this.getUserAgent());
                            conn.setRequestMethod("POST");
                            conn.setDoInput(true);
                            conn.setDoOutput(true);
                            wr = conn.getOutputStream();
                            wr.write(currentRequest.requestObj.toString().getBytes("utf-8"));
                            wr.flush();
                            wr.close();
                            respCode = conn.getResponseCode();
                            if (respCode == 200 || respCode == 202) ** GOTO lbl-1000
                            isErrorResponse = true;
                            is = conn.getInputStream();
                            rd = new BufferedReader(new InputStreamReader(is));
                            response = new StringBuffer();
                            while ((line = rd.readLine()) != null) {
                                response.append(line);
                                response.append('\r');
                            }
                            Log.e((String)"NosaraClient", (String)("Server error response: " + response.toString()));
                            rd.close();
                            is.close();
                        }
                        catch (MalformedURLException e) {
                            Log.e((String)"NosaraClient", (String)"The REST endpoint URL is not valid!?!?! This should never happen", (Throwable)e);
                            isErrorResponse = true;
                        }
                        catch (IOException e) {
                            Log.e((String)"NosaraClient", (String)"Error while sending the events to the server", (Throwable)e);
                            isErrorResponse = true;
                        }
                        catch (Exception e) {
                            Log.e((String)"NosaraClient", (String)"Error while sending the events to the server", (Throwable)e);
                            isErrorResponse = true;
                        }
                        finally {
                            try {
                                if (conn != null) {
                                    conn.disconnect();
                                }
                            }
                            catch (Exception e) {}
                            if (isErrorResponse) {
                                this.reEnqueueEventsAndSetError(currentRequest);
                            }
                            TracksClient.access$402(TracksClient.this, 0L);
                        }
                        continue;
                    }
                    this.reEnqueueEventsAndSetError(currentRequest);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void reEnqueueEventsAndSetError(NetworkRequestObject request) {
                TracksClient.this.mLastNetworkErrorTimestamp = System.currentTimeMillis();
                LinkedList<Event> mustKeepEventsList = new LinkedList<Event>();
                for (Event singleEvent : request.src) {
                    if (!TracksClient.this.isStillValid(singleEvent)) continue;
                    singleEvent.addRetryCount();
                    mustKeepEventsList.add(singleEvent);
                }
                if (mustKeepEventsList.size() > 0) {
                    LinkedList linkedList = TracksClient.this.mInsertEventsQueue;
                    synchronized (linkedList) {
                        TracksClient.this.mInsertEventsQueue.addAll(mustKeepEventsList);
                        TracksClient.this.mInsertEventsQueue.notifyAll();
                    }
                }
            }
        });
        networkThread.setPriority(5);
        networkThread.start();
    }

    private static boolean checkBasicConfiguration(Context context) {
        String packageName;
        PackageManager packageManager = context.getPackageManager();
        if (0 != packageManager.checkPermission("android.permission.INTERNET", packageName = context.getPackageName())) {
            Log.e((String)LOGTAG, (String)"Package does not have permission android.permission.INTERNET - Nosara Client will not work at all!");
            Log.w((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", packageName)) {
            Log.e((String)LOGTAG, (String)"Package does not have permission android.permission.ACCESS_NETWORK_STATE - Nosara Client will not work at all!");
            Log.w((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />");
            return false;
        }
        if (0 != packageManager.checkPermission("android.permission.BLUETOOTH", packageName)) {
            Log.w((String)LOGTAG, (String)"Package does not have permission android.permission.BLUETOOTH - Nosara Client will not report BT state");
            Log.w((String)LOGTAG, (String)"You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"android.permission.BLUETOOTH\" />");
        }
        return true;
    }

    public void registerUserProperties(JSONObject props) {
        this.mUserProperties = props;
    }

    public void clearUserProperties() {
        this.mUserProperties = null;
    }

    public void flush() {
        Thread flushingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = mDbLock;
                synchronized (object) {
                    if (EventTable.getEventsCount(TracksClient.this.mContext) > 0) {
                        TracksClient.this.mPendingFlush = true;
                        mDbLock.notifyAll();
                    }
                }
            }
        });
        flushingThread.setPriority(1);
        flushingThread.start();
    }

    public void track(String eventName, String user, NosaraUserType userType) {
        this.track(eventName, null, user, userType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(String eventName, JSONObject customProps, String user, NosaraUserType userType) {
        Event event = null;
        try {
            event = new Event(eventName, user, userType, this.getUserAgent(), System.currentTimeMillis());
        }
        catch (EventNameException e) {
            Log.e((String)LOGTAG, (String)("Cannot create the event: " + eventName), (Throwable)e);
            return;
        }
        JSONObject deviceInfo = this.deviceInformation.getMutableDeviceInfo();
        if (deviceInfo != null && deviceInfo.length() > 0) {
            event.setDeviceInfo(deviceInfo);
        }
        if (this.mUserProperties != null && this.mUserProperties.length() > 0) {
            event.setUserProperties(this.mUserProperties);
        }
        if (customProps != null && customProps.length() > 0) {
            Iterator iter = customProps.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = customProps.get(key);
                    event.addCustomEventProperty(key, value);
                }
                catch (JSONException e) {
                    Log.e((String)LOGTAG, (String)("Cannot add the property '" + key + "' to the event"));
                }
            }
        }
        LinkedList<Event> linkedList = this.mInsertEventsQueue;
        synchronized (linkedList) {
            this.mInsertEventsQueue.add(event);
            this.mInsertEventsQueue.notify();
        }
    }

    public void trackAliasUser(String user, String anonUser, NosaraUserType userType) {
        JSONObject customProps = new JSONObject();
        try {
            customProps.put("anonId", (Object)anonUser);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)("Cannot track _aliasUser with the following anonUser " + anonUser));
            return;
        }
        this.track("_aliasUser", customProps, user, userType);
    }

    public void trackAliasUser(String user, String anonUser) {
        this.trackAliasUser(user, anonUser, NosaraUserType.WPCOM);
    }

    private String getAbsoluteURL(String url) {
        if (url.indexOf(this.mRestApiEndpointURL) == 0) {
            return url;
        }
        if (url.indexOf("/") == 0) {
            url = url.substring(1);
        }
        return String.format("%s%s", this.mRestApiEndpointURL, url);
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    private boolean isStillValid(Event event) {
        return true;
    }

    static /* synthetic */ String access$1100(TracksClient x0) {
        return x0.mTracksRestEndpointURL;
    }

    private final class NetworkRequestObject {
        JSONObject requestObj;
        List<Event> src;

        private NetworkRequestObject() {
        }
    }

    public static enum NosaraUserType {
        ANON,
        WPCOM,
        SIMPLENOTE;

    }
}

