/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks.datasets;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import com.automattic.android.tracks.Event;
import com.automattic.android.tracks.Exceptions.EventNameException;
import com.automattic.android.tracks.TracksClient;
import com.automattic.android.tracks.datasets.SqlUtils;
import com.automattic.android.tracks.datasets.TracksDatabaseHelper;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;

public class EventTable {
    protected static void createTables(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE tbl_events ( event_id        INTEGER PRIMARY KEY ASC, event_name      TEXT NOT NULL, user            TEXT NOT NULL, user_agent      TEXT, timestamp       INTEGER, retry_count     INTEGER DEFAULT 0, user_type       INTEGER DEFAULT 0, user_props      TEXT, device_info     TEXT, custom_props    TEXT)");
    }

    protected static void dropTables(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS tbl_events");
    }

    protected static void reset(SQLiteDatabase db) {
        EventTable.dropTables(db);
        EventTable.createTables(db);
    }

    public static boolean hasEvents(Context ctx) {
        return EventTable.getEventsCount(ctx) > 0;
    }

    public static int getEventsCount(Context ctx) {
        if (ctx == null) {
            Log.e((String)"NosaraDB", (String)"Cannot access the event table since the passed context is null. Context is required to access the DB.");
            return 0;
        }
        SQLiteDatabase db = TracksDatabaseHelper.getReadableDb(ctx);
        return (int)SqlUtils.getRowCount(db, "tbl_events");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertEvent(Context ctx, Event event) {
        if (event == null) {
            Log.e((String)"NosaraDB", (String)"Cannot insert a null event");
            return;
        }
        if (ctx == null) {
            Log.e((String)"NosaraDB", (String)"Cannot insert a null event since the passed context is null. Context is required to access the DB.");
            return;
        }
        SQLiteDatabase db = TracksDatabaseHelper.getWritableDb(ctx);
        db.beginTransaction();
        SQLiteStatement stmt = db.compileStatement("INSERT INTO tbl_events (event_name, user, user_agent, user_type, user_props, device_info, custom_props, timestamp, retry_count) VALUES (?1,?2,?3,?4,?5,?6,?7,?8, ?9)");
        try {
            stmt.bindString(1, event.getEventName());
            stmt.bindString(2, event.getUser());
            stmt.bindString(3, event.getUserAgent());
            stmt.bindLong(4, (long)event.getUserType().ordinal());
            if (event.getUserProperties() != null) {
                stmt.bindString(5, event.getUserProperties().toString());
            } else {
                stmt.bindNull(5);
            }
            if (event.getDeviceInfo() != null) {
                stmt.bindString(6, event.getDeviceInfo().toString());
            } else {
                stmt.bindNull(6);
            }
            if (event.getCustomEventProperties() != null) {
                stmt.bindString(7, event.getCustomEventProperties().toString());
            } else {
                stmt.bindNull(7);
            }
            stmt.bindLong(8, event.getTimeStamp());
            stmt.bindLong(9, (long)event.getRetryCount());
            stmt.execute();
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
            SqlUtils.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<Event> getAndDeleteEvents(Context ctx, int maxEvents) {
        if (ctx == null) {
            Log.e((String)"NosaraDB", (String)"Cannot load events!  The passed context is null. Context is required to access the DB.");
            return null;
        }
        String sql = "SELECT * FROM tbl_events ORDER BY tbl_events.event_id ASC";
        if (maxEvents > 0) {
            sql = sql + " LIMIT " + Integer.toString(maxEvents);
        }
        SQLiteDatabase db = TracksDatabaseHelper.getWritableDb(ctx);
        db.beginTransaction();
        Cursor cursor = db.rawQuery(sql, new String[0]);
        LinkedList<Event> events = new LinkedList<Event>();
        LinkedList<Long> idToDelete = new LinkedList<Long>();
        try {
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    idToDelete.add(cursor.getLong(cursor.getColumnIndex("event_id")));
                    String eventName = cursor.getString(cursor.getColumnIndex("event_name"));
                    String user = cursor.getString(cursor.getColumnIndex("user"));
                    String userAgent = !cursor.isNull(cursor.getColumnIndex("user_agent")) ? cursor.getString(cursor.getColumnIndex("user_agent")) : null;
                    int uTypeCardinal = (int)cursor.getLong(cursor.getColumnIndex("user_type"));
                    TracksClient.NosaraUserType userType = TracksClient.NosaraUserType.values()[uTypeCardinal];
                    long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                    String userProps = !cursor.isNull(cursor.getColumnIndex("user_props")) ? cursor.getString(cursor.getColumnIndex("user_props")) : null;
                    String deviceInfo = !cursor.isNull(cursor.getColumnIndex("device_info")) ? cursor.getString(cursor.getColumnIndex("device_info")) : null;
                    String customProps = !cursor.isNull(cursor.getColumnIndex("custom_props")) ? cursor.getString(cursor.getColumnIndex("custom_props")) : null;
                    try {
                        Event currentEvent = new Event(eventName, user, userType, userAgent, timestamp);
                        if (deviceInfo != null) {
                            currentEvent.setDeviceInfo(new JSONObject(deviceInfo));
                        }
                        if (userProps != null) {
                            currentEvent.setUserProperties(new JSONObject(userProps));
                        }
                        if (customProps != null) {
                            currentEvent.setCustomProperties(new JSONObject(customProps));
                        }
                        events.add(currentEvent);
                    }
                    catch (EventNameException e) {
                        Log.e((String)"NosaraDB", (String)"Cannot load event from the DB!  Name of the event is not correct?!?", (Throwable)e);
                    }
                    catch (JSONException e) {
                        Log.e((String)"NosaraDB", (String)"Cannot recreate the event obj from the DB data!", (Throwable)e);
                    }
                    catch (Exception e) {
                        Log.e((String)"NosaraDB", (String)"Cannot recreate the event obj from the DB data!", (Throwable)e);
                    }
                } while (cursor.moveToNext());
            }
            if (maxEvents <= 0) {
                db.execSQL("DELETE FROM tbl_events");
            } else if (idToDelete.size() > 0) {
                StringBuilder deleteInClause = new StringBuilder();
                boolean first = true;
                for (Long currentID : idToDelete) {
                    if (first) {
                        deleteInClause.append(currentID.toString());
                        first = false;
                        continue;
                    }
                    deleteInClause.append(" ,");
                    deleteInClause.append(currentID.toString());
                }
                int numDeleted = db.delete("tbl_events", "event_id IN (" + deleteInClause.toString() + ")", null);
                Log.d((String)"NosaraDB", (String)("Deleted " + numDeleted + " rows from the Events table."));
            }
            db.setTransactionSuccessful();
            LinkedList<Event> linkedList = events;
            return linkedList;
        }
        finally {
            db.endTransaction();
            SqlUtils.closeCursor(cursor);
        }
    }

    public static void purgeAll(Context ctx) {
        if (ctx == null) {
            Log.e((String)"NosaraDB", (String)"Cannot purge the events table!  The passed context is null. Context is required to access the DB.");
            return;
        }
        SQLiteDatabase db = TracksDatabaseHelper.getWritableDb(ctx);
        db.beginTransaction();
        try {
            db.execSQL("DELETE FROM tbl_events");
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }
}

