/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks.datasets;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import java.util.ArrayList;

public class SqlUtils {
    private SqlUtils() {
        throw new AssertionError();
    }

    public static long boolToSql(boolean value) {
        return value ? 1 : 0;
    }

    public static boolean sqlToBool(int value) {
        return value != 0;
    }

    public static void closeStatement(SQLiteStatement stmt) {
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void closeCursor(Cursor c) {
        if (c != null && !c.isClosed()) {
            c.close();
        }
    }

    public static long longForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try {
            return DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)query, (String[])selectionArgs);
        }
        catch (SQLiteDoneException e) {
            return 0L;
        }
    }

    public static int intForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        long value = SqlUtils.longForQuery(db, query, selectionArgs);
        return (int)value;
    }

    public static boolean boolForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        long value = SqlUtils.longForQuery(db, query, selectionArgs);
        return SqlUtils.sqlToBool((int)value);
    }

    public static String stringForQuery(SQLiteDatabase db, String query, String[] selectionArgs) {
        try {
            return DatabaseUtils.stringForQuery((SQLiteDatabase)db, (String)query, (String[])selectionArgs);
        }
        catch (SQLiteDoneException e) {
            return "";
        }
    }

    public static long getRowCount(SQLiteDatabase db, String tableName) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)tableName);
    }

    public static void deleteAllRowsInTable(SQLiteDatabase db, String tableName) {
        db.delete(tableName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dropAllTables(SQLiteDatabase db) throws SQLiteException {
        if (db == null) {
            return false;
        }
        if (db.isReadOnly()) {
            throw new SQLiteException("can't drop tables from a read-only database");
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        Cursor cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", null);
        if (cursor.moveToFirst()) {
            do {
                String tableName;
                if ((tableName = cursor.getString(0)).equals("android_metadata") || tableName.equals("sqlite_sequence")) continue;
                tableNames.add(tableName);
            } while (cursor.moveToNext());
        }
        db.beginTransaction();
        try {
            for (String tableName : tableNames) {
                db.execSQL("DROP TABLE IF EXISTS " + tableName);
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        finally {
            db.endTransaction();
        }
    }
}

