/*
 * Decompiled with CFR 0.152.
 */
package com.automattic.android.tracks.datasets;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.automattic.android.tracks.datasets.EventTable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TracksDatabaseHelper
extends SQLiteOpenHelper {
    public static final String LOGTAG = "NosaraDB";
    protected static final String DB_NAME = "tracks.db";
    private static final int DB_VERSION = 1;
    private static TracksDatabaseHelper mDatabaseHelper;
    private static final Object mDbLock;
    private final Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TracksDatabaseHelper getDatabase(Context ctx) {
        if (mDatabaseHelper == null) {
            Object object = mDbLock;
            synchronized (object) {
                if (mDatabaseHelper == null) {
                    mDatabaseHelper = new TracksDatabaseHelper(ctx);
                    mDatabaseHelper.getWritableDatabase();
                }
            }
        }
        return mDatabaseHelper;
    }

    private TracksDatabaseHelper(Context context) {
        super(context, DB_NAME, null, 1);
        this.mContext = context;
    }

    public static SQLiteDatabase getReadableDb(Context ctx) {
        return TracksDatabaseHelper.getDatabase(ctx).getReadableDatabase();
    }

    public static SQLiteDatabase getWritableDb(Context ctx) {
        return TracksDatabaseHelper.getDatabase(ctx).getWritableDatabase();
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
    }

    public void reset(SQLiteDatabase db) {
        db.beginTransaction();
        try {
            this.dropAllTables(db);
            this.createAllTables(db);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    public void onCreate(SQLiteDatabase db) {
        this.createAllTables(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i((String)LOGTAG, (String)("Upgrading database from version " + oldVersion + " to version " + newVersion));
        this.reset(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.w((String)LOGTAG, (String)("Downgrading database from version " + oldVersion + " to version " + newVersion));
        this.reset(db);
    }

    private void createAllTables(SQLiteDatabase db) {
        EventTable.createTables(db);
    }

    private void dropAllTables(SQLiteDatabase db) {
        EventTable.dropTables(db);
    }

    private void copyDatabase(SQLiteDatabase db) {
        String copyFrom = db.getPath();
        String copyTo = this.mContext.getExternalFilesDir(null).getAbsolutePath() + "/" + DB_NAME;
        try {
            int length;
            FileInputStream input = new FileInputStream(copyFrom);
            FileOutputStream output = new FileOutputStream(copyTo);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
            output.flush();
            ((OutputStream)output).close();
            ((InputStream)input).close();
        }
        catch (IOException e) {
            Log.e((String)LOGTAG, (String)"failed to copy tracks database", (Throwable)e);
        }
    }

    static {
        mDbLock = new Object();
    }
}

