/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.stringtemplate.v4;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import shadow.org.stringtemplate.v4.AttributeRenderer;

public class StringRenderer
implements AttributeRenderer<Object> {
    @Override
    public String toString(Object value, String formatString, Locale locale) {
        return this.toString((String)value, formatString, locale);
    }

    @Override
    public String toString(String value, String formatString, Locale locale) {
        if (formatString == null) {
            return value;
        }
        if (formatString.equals("upper")) {
            return value.toUpperCase(locale);
        }
        if (formatString.equals("lower")) {
            return value.toLowerCase(locale);
        }
        if (formatString.equals("cap")) {
            return value.length() > 0 ? Character.toUpperCase(value.charAt(0)) + value.substring(1) : value;
        }
        if (formatString.equals("url-encode")) {
            try {
                return URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (formatString.equals("xml-encode")) {
            return StringRenderer.escapeHTML(value);
        }
        return String.format(locale, formatString, value);
    }

    public static String escapeHTML(String s) {
        int c;
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s.length());
        int len = s.length();
        block6: for (int i = 0; i < len; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            switch (c) {
                case 38: {
                    buf.append("&amp;");
                    continue block6;
                }
                case 60: {
                    buf.append("&lt;");
                    continue block6;
                }
                case 62: {
                    buf.append("&gt;");
                    continue block6;
                }
                case 9: 
                case 10: 
                case 13: {
                    buf.append((char)c);
                    continue block6;
                }
                default: {
                    boolean aboveASCII;
                    boolean control = c < 32;
                    boolean bl = aboveASCII = c > 126;
                    if (control || aboveASCII) {
                        buf.append("&#");
                        buf.append(c);
                        buf.append(";");
                        continue block6;
                    }
                    buf.append((char)c);
                }
            }
        }
        return buf.toString();
    }
}

