/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.antlr.v4.codegen;

import com.autonomousapps.internal.antlr.v4.codegen.CodeGenerator;
import com.autonomousapps.internal.antlr.v4.tool.ErrorType;
import com.autonomousapps.internal.antlr.v4.tool.Grammar;
import shadow.org.stringtemplate.v4.ST;
import shadow.org.stringtemplate.v4.gui.STViz;

public class CodeGenPipeline {
    final Grammar g;
    final CodeGenerator gen;

    public CodeGenPipeline(Grammar g, CodeGenerator gen) {
        this.g = g;
        this.gen = gen;
    }

    public void process() {
        int errorCount = this.g.tool.errMgr.getNumErrors();
        if (this.g.isLexer()) {
            ST lexer;
            if (this.gen.getTarget().needsHeader()) {
                lexer = this.gen.generateLexer(true);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    this.writeRecognizer(lexer, this.gen, true);
                }
            }
            lexer = this.gen.generateLexer(false);
            if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                this.writeRecognizer(lexer, this.gen, false);
            }
        } else {
            ST parser;
            if (this.gen.getTarget().needsHeader()) {
                parser = this.gen.generateParser(true);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    this.writeRecognizer(parser, this.gen, true);
                }
            }
            parser = this.gen.generateParser(false);
            if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                this.writeRecognizer(parser, this.gen, false);
            }
            if (this.g.tool.gen_listener) {
                ST baseListener;
                ST listener;
                if (this.gen.getTarget().needsHeader()) {
                    listener = this.gen.generateListener(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        this.gen.writeListener(listener, true);
                    }
                }
                listener = this.gen.generateListener(false);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    this.gen.writeListener(listener, false);
                }
                if (this.gen.getTarget().needsHeader()) {
                    baseListener = this.gen.generateBaseListener(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        this.gen.writeBaseListener(baseListener, true);
                    }
                }
                if (this.gen.getTarget().wantsBaseListener()) {
                    baseListener = this.gen.generateBaseListener(false);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        this.gen.writeBaseListener(baseListener, false);
                    }
                }
            }
            if (this.g.tool.gen_visitor) {
                ST baseVisitor;
                ST visitor;
                if (this.gen.getTarget().needsHeader()) {
                    visitor = this.gen.generateVisitor(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        this.gen.writeVisitor(visitor, true);
                    }
                }
                visitor = this.gen.generateVisitor(false);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    this.gen.writeVisitor(visitor, false);
                }
                if (this.gen.getTarget().needsHeader()) {
                    baseVisitor = this.gen.generateBaseVisitor(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        this.gen.writeBaseVisitor(baseVisitor, true);
                    }
                }
                if (this.gen.getTarget().wantsBaseVisitor()) {
                    baseVisitor = this.gen.generateBaseVisitor(false);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        this.gen.writeBaseVisitor(baseVisitor, false);
                    }
                }
            }
        }
        this.gen.writeVocabFile();
    }

    protected void writeRecognizer(ST template, CodeGenerator gen, boolean header) {
        if (this.g.tool.launch_ST_inspector) {
            STViz viz = template.inspect();
            if (this.g.tool.ST_inspector_wait_for_close) {
                try {
                    viz.waitForClose();
                }
                catch (InterruptedException ex) {
                    this.g.tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, ex, new Object[0]);
                }
            }
        }
        gen.writeRecognizer(template, header);
    }
}

