/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.json;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import shadow.javax.json.JsonArrayBuilder;
import shadow.javax.json.JsonBuilderFactory;
import shadow.javax.json.JsonObjectBuilder;
import shadow.javax.json.JsonReader;
import shadow.javax.json.JsonReaderFactory;
import shadow.javax.json.JsonWriter;
import shadow.javax.json.JsonWriterFactory;
import shadow.javax.json.spi.JsonProvider;
import shadow.javax.json.stream.JsonGenerator;
import shadow.javax.json.stream.JsonGeneratorFactory;
import shadow.javax.json.stream.JsonParser;
import shadow.javax.json.stream.JsonParserFactory;
import shadow.org.glassfish.json.BufferPoolImpl;
import shadow.org.glassfish.json.JsonArrayBuilderImpl;
import shadow.org.glassfish.json.JsonBuilderFactoryImpl;
import shadow.org.glassfish.json.JsonGeneratorFactoryImpl;
import shadow.org.glassfish.json.JsonGeneratorImpl;
import shadow.org.glassfish.json.JsonObjectBuilderImpl;
import shadow.org.glassfish.json.JsonParserFactoryImpl;
import shadow.org.glassfish.json.JsonParserImpl;
import shadow.org.glassfish.json.JsonReaderFactoryImpl;
import shadow.org.glassfish.json.JsonReaderImpl;
import shadow.org.glassfish.json.JsonWriterFactoryImpl;
import shadow.org.glassfish.json.JsonWriterImpl;
import shadow.org.glassfish.json.api.BufferPool;

public class JsonProviderImpl
extends JsonProvider {
    private final BufferPool bufferPool = new BufferPoolImpl();

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return new JsonGeneratorImpl(out, this.bufferPool);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new JsonParserImpl(reader, this.bufferPool);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return new JsonParserImpl(in, this.bufferPool);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonParserFactoryImpl(pool);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        BufferPool pool;
        boolean prettyPrinting;
        Map<String, Object> providerConfig;
        if (config == null) {
            providerConfig = Collections.emptyMap();
            prettyPrinting = false;
            pool = this.bufferPool;
        } else {
            providerConfig = new HashMap();
            prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
            if (prettyPrinting) {
                providerConfig.put("shadow.javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((pool = (BufferPool)config.get(BufferPool.class.getName())) != null) {
                providerConfig.put(BufferPool.class.getName(), pool);
            } else {
                pool = this.bufferPool;
            }
            providerConfig = Collections.unmodifiableMap(providerConfig);
        }
        return new JsonGeneratorFactoryImpl(providerConfig, prettyPrinting, pool);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(reader, this.bufferPool);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(in, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return new JsonWriterImpl(out, this.bufferPool);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        BufferPool pool;
        boolean prettyPrinting;
        Map<String, Object> providerConfig;
        if (config == null) {
            providerConfig = Collections.emptyMap();
            prettyPrinting = false;
            pool = this.bufferPool;
        } else {
            providerConfig = new HashMap();
            prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
            if (prettyPrinting) {
                providerConfig.put("shadow.javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((pool = (BufferPool)config.get(BufferPool.class.getName())) != null) {
                providerConfig.put(BufferPool.class.getName(), pool);
            } else {
                pool = this.bufferPool;
            }
            providerConfig = Collections.unmodifiableMap(providerConfig);
        }
        return new JsonWriterFactoryImpl(providerConfig, prettyPrinting, pool);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonReaderFactoryImpl(pool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        BufferPool pool = null;
        if (config != null && config.containsKey(BufferPool.class.getName())) {
            pool = (BufferPool)config.get(BufferPool.class.getName());
        }
        if (pool == null) {
            pool = this.bufferPool;
        }
        return new JsonBuilderFactoryImpl(pool);
    }

    static boolean isPrettyPrintingEnabled(Map<String, ?> config) {
        return config.containsKey("shadow.javax.json.stream.JsonGenerator.prettyPrinting");
    }
}

