/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.ibm.icu.impl.number.parse;

import java.util.ArrayList;
import java.util.List;
import shadow.com.ibm.icu.impl.StringSegment;
import shadow.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import shadow.com.ibm.icu.impl.number.parse.ParsedNumber;
import shadow.com.ibm.icu.text.UnicodeSet;

public class AnyMatcher
implements NumberParseMatcher {
    protected List<NumberParseMatcher> matchers = null;
    protected boolean frozen = false;

    public void addMatcher(NumberParseMatcher matcher) {
        assert (!this.frozen);
        if (this.matchers == null) {
            this.matchers = new ArrayList<NumberParseMatcher>();
        }
        this.matchers.add(matcher);
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result) {
        assert (this.frozen);
        if (this.matchers == null) {
            return false;
        }
        int initialOffset = segment.getOffset();
        boolean maybeMore = false;
        for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            boolean bl = maybeMore = maybeMore || matcher.match(segment, result);
            if (segment.getOffset() != initialOffset) break;
        }
        return maybeMore;
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        assert (this.frozen);
        if (this.matchers == null) {
            return UnicodeSet.EMPTY;
        }
        if (this.matchers.size() == 1) {
            return this.matchers.get(0).getLeadCodePoints();
        }
        UnicodeSet leadCodePoints = new UnicodeSet();
        for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            leadCodePoints.addAll(matcher.getLeadCodePoints());
        }
        return leadCodePoints.freeze();
    }

    @Override
    public void postProcess(ParsedNumber result) {
        assert (this.frozen);
        if (this.matchers == null) {
            return;
        }
        for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            matcher.postProcess(result);
        }
    }

    public String toString() {
        return "<AnyMatcher " + this.matchers + ">";
    }
}

