/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.utils;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.autonomousapps.internal.utils.AgpVersion;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.GroovyBuilderScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a \u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u0014"}, d2={"getBundleTaskName", "", "agpVersion", "variantName", "getBundleTaskOutput", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "project", "Lorg/gradle/api/Project;", "getBundleTaskType", "Ljava/lang/Class;", "Lorg/gradle/api/Task;", "getOutputMethod", "Ljava/lang/reflect/Method;", "type", "getOutputPropertyName", "isDataBindingEnabled", "", "Lcom/android/build/gradle/BaseExtension;", "isViewBindingEnabled", "dependency-analysis-gradle-plugin"})
public final class AgpUtilsKt {
    @NotNull
    public static final Provider<RegularFile> getBundleTaskOutput(@NotNull Project project, @NotNull String agpVersion, @NotNull String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)agpVersion, (String)"agpVersion");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        String bundleTaskName = AgpUtilsKt.getBundleTaskName(agpVersion, variantName);
        Class<? extends Task> type = AgpUtilsKt.getBundleTaskType(agpVersion);
        TaskProvider taskProvider = project.getTasks().named(bundleTaskName, type);
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.named(bundleTaskName, type)");
        TaskProvider task = taskProvider;
        Method outputMethod = AgpUtilsKt.getOutputMethod(type, agpVersion);
        Provider provider = task.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, Task>(outputMethod){
            final /* synthetic */ Method $outputMethod;

            @NotNull
            public final Provider<? extends RegularFile> transform(@NotNull Task it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Object object = this.$outputMethod.invoke((Object)it, new Object[0]);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.file.RegularFileProperty");
                }
                return (Provider)((RegularFileProperty)object);
            }
            {
                this.$outputMethod = method;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"task.flatMap {\n    outpu\u2026s RegularFileProperty\n  }");
        return provider;
    }

    private static final Method getOutputMethod(Class<? extends Task> type, String agpVersion) {
        Method method;
        try {
            method = type.getDeclaredMethod(AgpUtilsKt.getOutputPropertyName(agpVersion), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw (Throwable)new GradleException("Cannot find output method name for AGP " + agpVersion);
        }
        return method;
    }

    private static final String getBundleTaskName(String agpVersion, String variantName) {
        return StringsKt.startsWith$default((String)agpVersion, (String)"4.1", (boolean)false, (int)2, null) ? "bundleLibCompileToJar" + variantName : (StringsKt.startsWith$default((String)agpVersion, (String)"4.0", (boolean)false, (int)2, null) ? "bundleLibCompileToJar" + variantName : (StringsKt.startsWith$default((String)agpVersion, (String)"3.6", (boolean)false, (int)2, null) ? "bundleLibCompile" + variantName : (StringsKt.startsWith$default((String)agpVersion, (String)"3.5", (boolean)false, (int)2, null) ? "bundleLibCompile" + variantName : "bundleLibCompile" + variantName)));
    }

    private static final Class<? extends Task> getBundleTaskType(String agpVersion) {
        Class<?> clazz;
        try {
            Class<?> clazz2;
            if (StringsKt.startsWith$default((String)agpVersion, (String)"4.1", (boolean)false, (int)2, null)) {
                Class<?> clazz3 = Class.forName("com.android.build.gradle.internal.tasks.BundleLibraryClassesJar");
                clazz2 = clazz3;
                Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"Class.forName(\"com.andro\u2026BundleLibraryClassesJar\")");
            } else {
                Class<?> clazz4 = Class.forName("com.android.build.gradle.internal.tasks.BundleLibraryClasses");
                clazz2 = clazz4;
                Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"Class.forName(\"com.andro\u2026ks.BundleLibraryClasses\")");
            }
            if (clazz2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<org.gradle.api.Task>");
            }
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            throw (Throwable)new GradleException("Cannot find bundle class for AGP " + agpVersion);
        }
        return clazz;
    }

    private static final String getOutputPropertyName(String agpVersion) {
        return StringsKt.startsWith$default((String)agpVersion, (String)"4.1", (boolean)false, (int)2, null) ? "getOutput" : (StringsKt.startsWith$default((String)agpVersion, (String)"4.0", (boolean)false, (int)2, null) ? "getJarOutput" : (StringsKt.startsWith$default((String)agpVersion, (String)"3.6", (boolean)false, (int)2, null) ? "getOutput" : (StringsKt.startsWith$default((String)agpVersion, (String)"3.5", (boolean)false, (int)2, null) ? "getOutput" : "getOutput")));
    }

    public static final boolean isViewBindingEnabled(@NotNull BaseExtension $this$isViewBindingEnabled, @NotNull String agpVersion) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isViewBindingEnabled, (String)"$this$isViewBindingEnabled");
        Intrinsics.checkParameterIsNotNull((Object)agpVersion, (String)"agpVersion");
        if (AgpVersion.Companion.version(agpVersion).compareTo(AgpVersion.Companion.version("3.6")) < 0) {
            bl = false;
        } else if (AgpVersion.Companion.version(agpVersion).compareTo(AgpVersion.Companion.version("4.0")) >= 0) {
            BaseExtension $this$withGroovyBuilder$iv = $this$isViewBindingEnabled;
            boolean $i$f$withGroovyBuilder = false;
            GroovyBuilderScope $this$withGroovyBuilder = GroovyBuilderScope.Companion.of((Object)$this$withGroovyBuilder$iv);
            boolean bl2 = false;
            Object object = $this$withGroovyBuilder.getProperty("buildFeatures");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProperty(\"buildFeatures\")");
            Object $this$withGroovyBuilder$iv2 = object;
            boolean $i$f$withGroovyBuilder2 = false;
            GroovyBuilderScope $this$withGroovyBuilder2 = GroovyBuilderScope.Companion.of($this$withGroovyBuilder$iv2);
            boolean bl3 = false;
            Boolean bl4 = (Boolean)$this$withGroovyBuilder2.getProperty("viewBinding");
            bl = bl4 != null ? bl4 : false;
        } else {
            bl = $this$isViewBindingEnabled.getViewBinding().isEnabled();
        }
        return bl;
    }

    public static final boolean isDataBindingEnabled(@NotNull BaseExtension $this$isDataBindingEnabled, @NotNull String agpVersion) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isDataBindingEnabled, (String)"$this$isDataBindingEnabled");
        Intrinsics.checkParameterIsNotNull((Object)agpVersion, (String)"agpVersion");
        if (AgpVersion.Companion.version(agpVersion).compareTo(AgpVersion.Companion.version("4.0")) >= 0) {
            BaseExtension $this$withGroovyBuilder$iv = $this$isDataBindingEnabled;
            boolean $i$f$withGroovyBuilder = false;
            GroovyBuilderScope $this$withGroovyBuilder = GroovyBuilderScope.Companion.of((Object)$this$withGroovyBuilder$iv);
            boolean bl2 = false;
            Object object = $this$withGroovyBuilder.getProperty("buildFeatures");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProperty(\"buildFeatures\")");
            Object $this$withGroovyBuilder$iv2 = object;
            boolean $i$f$withGroovyBuilder2 = false;
            GroovyBuilderScope $this$withGroovyBuilder2 = GroovyBuilderScope.Companion.of($this$withGroovyBuilder$iv2);
            boolean bl3 = false;
            Boolean bl4 = (Boolean)$this$withGroovyBuilder2.getProperty("dataBinding");
            bl = bl4 != null ? bl4 : false;
        } else {
            DataBindingOptions dataBindingOptions = $this$isDataBindingEnabled.getDataBinding();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataBindingOptions, (String)"dataBinding");
            bl = dataBindingOptions.isEnabled();
        }
        return bl;
    }
}

