/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.utils;

import com.autonomousapps.internal.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0017H\u0000\u001a\u001c\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0000\u001a-\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020\u001e0\"H\u0080\b\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0013*\u00020\u0017H\u0000\u001a\u0012\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\r*\u00020%H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\u00a8\u0006&"}, d2={"DESC_REGEX", "Lkotlin/text/Regex;", "getDESC_REGEX", "()Lkotlin/text/Regex;", "JAVA_FQCN_REGEX", "getJAVA_FQCN_REGEX", "JAVA_FQCN_REGEX_SLASHY", "getJAVA_FQCN_REGEX_SLASHY", "METHOD_DESCRIPTOR_REGEX", "getMETHOD_DESCRIPTOR_REGEX", "printDependencyTree", "", "dependencies", "", "Lorg/gradle/api/artifacts/result/DependencyResult;", "level", "", "allItems", "", "", "Lkotlin/sequences/Sequence;", "Lkotlin/text/MatchResult;", "asString", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "namedOrNull", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "Lorg/gradle/api/tasks/TaskContainer;", "name", "reallyAll", "", "T", "", "predicate", "Lkotlin/Function1;", "resolvedVersion", "toIdentifiers", "Lorg/gradle/api/artifacts/DependencySet;", "dependency-analysis-gradle-plugin"})
public final class UtilsKt {
    @NotNull
    private static final Regex METHOD_DESCRIPTOR_REGEX;
    @NotNull
    private static final Regex DESC_REGEX;
    @NotNull
    private static final Regex JAVA_FQCN_REGEX;
    @NotNull
    private static final Regex JAVA_FQCN_REGEX_SLASHY;

    public static final <T> boolean reallyAll(@NotNull Collection<? extends T> $this$reallyAll, @NotNull Function1<? super T, Boolean> predicate2) {
        int $i$f$reallyAll = 0;
        Intrinsics.checkParameterIsNotNull($this$reallyAll, (String)"$this$reallyAll");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        if ($this$reallyAll.isEmpty()) {
            return false;
        }
        for (T element : $this$reallyAll) {
            if (((Boolean)predicate2.invoke(element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final List<String> allItems(@NotNull Sequence<? extends MatchResult> $this$allItems) {
        Intrinsics.checkParameterIsNotNull($this$allItems, (String)"$this$allItems");
        return SequencesKt.toList((Sequence)SequencesKt.flatMap($this$allItems, (Function1)allItems.1.INSTANCE));
    }

    @NotNull
    public static final String asString(@NotNull ComponentIdentifier $this$asString) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$asString, (String)"$this$asString");
        ComponentIdentifier componentIdentifier = $this$asString;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            String string2 = ((ProjectComponentIdentifier)$this$asString).getProjectPath();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"projectPath");
        } else if (componentIdentifier instanceof ModuleComponentIdentifier) {
            string = ((ModuleComponentIdentifier)$this$asString).getModuleIdentifier().toString();
        } else {
            throw (Throwable)new GradleException("Cannot identify ComponentIdentifier subtype. Was " + $this$asString.getClass().getSimpleName() + ", named " + $this$asString);
        }
        return string;
    }

    @Nullable
    public static final String resolvedVersion(@NotNull ComponentIdentifier $this$resolvedVersion) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$resolvedVersion, (String)"$this$resolvedVersion");
        ComponentIdentifier componentIdentifier = $this$resolvedVersion;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            string = null;
        } else if (componentIdentifier instanceof ModuleComponentIdentifier) {
            string = ((ModuleComponentIdentifier)$this$resolvedVersion).getVersion();
        } else {
            throw (Throwable)new GradleException("Cannot identify ComponentIdentifier subtype. Was " + $this$resolvedVersion.getClass().getSimpleName() + ", named " + $this$resolvedVersion);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> toIdentifiers(@NotNull DependencySet $this$toIdentifiers) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$toIdentifiers, (String)"$this$toIdentifiers");
        Iterable $this$mapNotNull$iv = (Iterable)$this$toIdentifiers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Dependency it = (Dependency)element$iv$iv;
            boolean bl2 = false;
            Dependency dependency = it;
            if (dependency instanceof ProjectDependency) {
                Project project = ((ProjectDependency)it).getDependencyProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it.dependencyProject");
                string = project.getPath();
            } else if (dependency instanceof ModuleDependency) {
                string = ((ModuleDependency)it).getGroup() + ':' + ((ModuleDependency)it).getName();
            } else if (dependency instanceof SelfResolvingDependency) {
                string = null;
            } else {
                throw (Throwable)new GradleException("Unknown Dependency subtype: \n" + it + '\n' + it.getClass().getName());
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Regex getMETHOD_DESCRIPTOR_REGEX() {
        return METHOD_DESCRIPTOR_REGEX;
    }

    @NotNull
    public static final Regex getDESC_REGEX() {
        return DESC_REGEX;
    }

    @NotNull
    public static final Regex getJAVA_FQCN_REGEX() {
        return JAVA_FQCN_REGEX;
    }

    @NotNull
    public static final Regex getJAVA_FQCN_REGEX_SLASHY() {
        return JAVA_FQCN_REGEX_SLASHY;
    }

    /*
     * WARNING - void declaration
     */
    public static final void printDependencyTree(@NotNull Set<? extends DependencyResult> dependencies, int level) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
        Iterable $this$filterIsInstance$iv = dependencies;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedComponentResult resolvedComponentResult;
            ResolvedDependencyResult result = (ResolvedDependencyResult)element$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)result.getSelected(), (String)"result.selected");
            String string = StringsKt.repeat((CharSequence)"  ", (int)level) + "- " + resolvedComponentResult.getId();
            boolean bl2 = false;
            System.out.println((Object)string);
            Set set = resolvedComponentResult.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"resolvedComponentResult.dependencies");
            UtilsKt.printDependencyTree(set, level + 1);
        }
    }

    public static /* synthetic */ void printDependencyTree$default(Set set, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        UtilsKt.printDependencyTree(set, n);
    }

    @Nullable
    public static final TaskProvider<Task> namedOrNull(@NotNull TaskContainer $this$namedOrNull, @NotNull String name) {
        TaskProvider taskProvider;
        Intrinsics.checkParameterIsNotNull((Object)$this$namedOrNull, (String)"$this$namedOrNull");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            taskProvider = $this$namedOrNull.named(name);
        }
        catch (UnknownTaskException _) {
            taskProvider = null;
        }
        return taskProvider;
    }

    static {
        String string = "L\\w[\\w/$]+;";
        boolean bl = false;
        METHOD_DESCRIPTOR_REGEX = new Regex(string);
        string = "L(\\w[\\w/$]+);";
        bl = false;
        DESC_REGEX = new Regex(string);
        string = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        bl = false;
        JAVA_FQCN_REGEX = new Regex(string);
        string = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*/)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        bl = false;
        JAVA_FQCN_REGEX_SLASHY = new Regex(string);
    }
}

