/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.Manifest;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.XmlKt;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/tasks/ManifestPackageExtractionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "manifestArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "manifestPackagesReport", "Lorg/gradle/api/file/RegularFileProperty;", "getManifestPackagesReport", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "extractPackageDeclarationFromManifest", "Lkotlin/Pair;", "", "", "manifest", "Ljava/io/File;", "getManifestFiles", "Lorg/gradle/api/file/FileCollection;", "hasAndroidComponent", "document", "Lorg/w3c/dom/Document;", "packageName", "setArtifacts", "dependency-analysis-gradle-plugin"})
public abstract class ManifestPackageExtractionTask
extends DefaultTask {
    private ArtifactCollection manifestArtifacts;

    public final void setArtifacts(@NotNull ArtifactCollection manifestArtifacts) {
        Intrinsics.checkParameterIsNotNull((Object)manifestArtifacts, (String)"manifestArtifacts");
        this.manifestArtifacts = manifestArtifacts;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getManifestFiles() {
        ArtifactCollection artifactCollection2 = this.manifestArtifacts;
        if (artifactCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
        }
        FileCollection fileCollection = artifactCollection2.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"manifestArtifacts.artifactFiles");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getManifestPackagesReport();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$toJson$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object = this.getManifestPackagesReport().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"manifestPackagesReport.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"manifestPackagesReport.get().asFile");
        File outputFile = file;
        outputFile.delete();
        ArtifactCollection artifactCollection2 = this.manifestArtifacts;
        if (artifactCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection2;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<String, Boolean> pair;
            Object object2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult manifest = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            try {
                void pn;
                ResolvedArtifactResult resolvedArtifactResult = manifest;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"manifest");
                File file2 = resolvedArtifactResult.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"manifest.file");
                object2 = this.extractPackageDeclarationFromManifest(file2);
                boolean bl3 = false;
                boolean bl4 = false;
                Pair<String, Boolean> $dstr$pn$hasComponent = object2;
                boolean bl5 = false;
                String string = (String)$dstr$pn$hasComponent.component1();
                boolean hasComponent = (Boolean)$dstr$pn$hasComponent.component2();
                ComponentArtifactIdentifier componentArtifactIdentifier = manifest.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"manifest.id");
                ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier, (String)"manifest.id.componentIdentifier");
                object2 = new Manifest((String)pn, hasComponent, componentIdentifier);
            }
            catch (GradleException _) {
                object2 = null;
            }
            if (object2 == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair<String, Boolean> it$iv$iv = pair;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set manifests = (TreeSet)destination$iv$iv;
        $this$mapNotNullToOrderedSet$iv = manifests;
        File file3 = outputFile;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Set.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        String string2 = string;
        FilesKt.writeText$default((File)file3, (String)string2, null, (int)2, null);
    }

    private final Pair<String, Boolean> extractPackageDeclarationFromManifest(File manifest) {
        Document document = XmlKt.buildDocument(manifest);
        return TuplesKt.to((Object)this.packageName(document), (Object)this.hasAndroidComponent(document));
    }

    private final String packageName(Document document) {
        Node node = document.getElementsByTagName("manifest").item(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"document.getElementsByTagName(\"manifest\").item(0)");
        Node node2 = node.getAttributes().getNamedItem("package");
        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"document.getElementsByTa\u2026 .getNamedItem(\"package\")");
        String string = node2.getNodeValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.getElementsByTa\u2026ackage\")\n      .nodeValue");
        return string;
    }

    private final boolean hasAndroidComponent(Document document) {
        NodeList nodeList = document.getElementsByTagName("service");
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"document.getElementsByTagName(\"service\")");
        if (nodeList.getLength() > 0) {
            return true;
        }
        NodeList nodeList2 = document.getElementsByTagName("provider");
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList2, (String)"document.getElementsByTagName(\"provider\")");
        return nodeList2.getLength() > 0;
    }

    public ManifestPackageExtractionTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Produces a report of packages, from other components, that are included via Android manifests");
    }
}

