/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.android;

import com.android.Version;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/internal/android/AgpVersion;", "", "version", "", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "versionNumber", "Lorg/gradle/util/VersionNumber;", "compareTo", "", "other", "equals", "", "", "hashCode", "isSupported", "toString", "Companion", "dependency-analysis-gradle-plugin"})
public final class AgpVersion
implements Comparable<AgpVersion> {
    private final VersionNumber versionNumber;
    @NotNull
    private final String version;
    @NotNull
    private static final AgpVersion AGP_MIN;
    @NotNull
    private static final AgpVersion AGP_MAX;
    public static final Companion Companion;

    public final boolean isSupported() {
        Comparable comparable = Companion.current();
        return comparable.compareTo((Comparable)AGP_MIN) >= 0 && comparable.compareTo((Comparable)AGP_MAX) <= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@NotNull AgpVersion other) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String string = this.versionNumber.getQualifier();
        if (string != null) {
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                String string2 = other.versionNumber.getQualifier();
                if (string2 != null) {
                    charSequence = string2;
                    bl = false;
                    if (charSequence.length() > 0) {
                        n = this.versionNumber.compareTo(other.versionNumber);
                        return n;
                    }
                }
            }
        }
        n = this.versionNumber.getBaseVersion().compareTo(other.versionNumber.getBaseVersion());
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.autonomousapps.internal.android.AgpVersion");
        }
        AgpVersion cfr_ignored_0 = (AgpVersion)object2;
        return this.versionNumber.equals((Object)((AgpVersion)other).versionNumber);
    }

    public int hashCode() {
        return this.versionNumber.hashCode();
    }

    @NotNull
    public String toString() {
        return "AgpVersion(versionNumber=" + this.versionNumber + ')';
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    private AgpVersion(String version) {
        this.version = version;
        VersionNumber versionNumber = VersionNumber.parse((String)this.version);
        Intrinsics.checkExpressionValueIsNotNull((Object)versionNumber, (String)"VersionNumber.parse(version)");
        this.versionNumber = versionNumber;
    }

    static {
        Companion = new Companion(null);
        AGP_MIN = Companion.version("3.5.3");
        AGP_MAX = Companion.version("4.2.0-alpha01");
    }

    public /* synthetic */ AgpVersion(String version, DefaultConstructorMarker $constructor_marker) {
        this(version);
    }

    @JvmStatic
    @NotNull
    public static final AgpVersion current() {
        return Companion.current();
    }

    @JvmStatic
    @NotNull
    public static final AgpVersion version(@NotNull String version) {
        return Companion.version(version);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/autonomousapps/internal/android/AgpVersion$Companion;", "", "()V", "AGP_MAX", "Lcom/autonomousapps/internal/android/AgpVersion;", "getAGP_MAX", "()Lcom/autonomousapps/internal/android/AgpVersion;", "AGP_MIN", "getAGP_MIN", "agpVersion", "", "current", "version", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final AgpVersion getAGP_MIN() {
            return AGP_MIN;
        }

        @NotNull
        public final AgpVersion getAGP_MAX() {
            return AGP_MAX;
        }

        @JvmStatic
        @NotNull
        public final AgpVersion current() {
            return new AgpVersion(this.agpVersion(), null);
        }

        @JvmStatic
        @NotNull
        public final AgpVersion version(@NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return new AgpVersion(version, null);
        }

        private final String agpVersion() {
            String string;
            try {
                string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            }
            catch (Throwable _) {
                string = com.android.builder.model.Version.ANDROID_GRADLE_PLUGIN_VERSION;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

