/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.DependencyConfiguration;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/autonomousapps/internal/ConfigurationsToDependenciesTransformer;", "", "flavorName", "", "variantName", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Ljava/lang/String;Lorg/gradle/api/Project;)V", "buildAPConfNames", "", "buildConfNames", "dependencyConfigurations", "Lcom/autonomousapps/internal/DependencyConfiguration;", "Companion", "dependency-analysis-gradle-plugin"})
public final class ConfigurationsToDependenciesTransformer {
    private final String flavorName;
    private final String variantName;
    private final Project project;
    private static final List<String> DEFAULT_CONFS;
    private static final List<String> DEFAULT_PROC_CONFS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DependencyConfiguration> dependencyConfigurations() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        boolean bl;
        Object object;
        Map.Entry $dstr$name$_u24__u24;
        Map $this$filterTo$iv$iv;
        Set candidateConfNames = SetsKt.plus(this.buildConfNames(), (Iterable)this.buildAPConfNames());
        ConfigurationContainer configurationContainer = this.project.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
        SortedMap sortedMap = configurationContainer.getAsMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)sortedMap, (String)"project.configurations.asMap");
        Map $this$filter$iv = sortedMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            $dstr$name$_u24__u24 = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            object = $dstr$name$_u24__u24;
            bl = false;
            String name = (String)object.getKey();
            if (!candidateConfNames.contains(name)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        bl2 = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            Configuration conf;
            void $dstr$_u24__u24$conf;
            $dstr$name$_u24__u24 = item$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl4 = false;
            object = $dstr$_u24__u24$conf;
            bl = false;
            Configuration configuration = conf = (Configuration)object.getValue();
            object2.add(configuration);
        }
        List interestingConfs = (List)destination$iv$iv;
        Iterable $this$flatMapToSet$iv = interestingConfs;
        boolean $i$f$flatMapToSet = false;
        $this$mapTo$iv$iv = $this$flatMapToSet$iv;
        destination$iv$iv = new HashSet(CollectionsKt.collectionSizeOrDefault($this$flatMapToSet$iv, 10));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Configuration conf = (Configuration)element$iv$iv;
            boolean bl5 = false;
            Configuration configuration = conf;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
            DependencySet dependencySet = configuration.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"conf.dependencies");
            Iterable $this$map$iv2 = GradleStringsKt.toIdentifiers(dependencySet);
            boolean $i$f$map2 = false;
            object = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void identifier;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                String string2 = conf.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"conf.name");
                DependencyConfiguration dependencyConfiguration = new DependencyConfiguration((String)identifier, string2);
                collection.add(dependencyConfiguration);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (HashSet)destination$iv$iv;
    }

    private final Set<String> buildConfNames() {
        String string;
        String it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = DEFAULT_CONFS;
        Collection collection2 = DEFAULT_CONFS;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = this.variantName + UtilsKt.capitalizeSafely$default(it, null, 1, null);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Set confNames = kotlin.collections.CollectionsKt.toMutableSet((Iterable)kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        if (this.flavorName != null) {
            $this$map$iv = DEFAULT_CONFS;
            collection2 = confNames;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = this.flavorName + UtilsKt.capitalizeSafely$default(it, null, 1, null);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            collection2.addAll(collection);
        }
        return confNames;
    }

    private final Set<String> buildAPConfNames() {
        String string;
        String it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = DEFAULT_PROC_CONFS;
        Collection collection2 = DEFAULT_PROC_CONFS;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it + UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Set procConfNames = kotlin.collections.CollectionsKt.toMutableSet((Iterable)kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        if (this.flavorName != null) {
            $this$map$iv = DEFAULT_PROC_CONFS;
            collection2 = procConfNames;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = it + UtilsKt.capitalizeSafely$default(this.flavorName, null, 1, null);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            collection2.addAll(collection);
        }
        return procConfNames;
    }

    public ConfigurationsToDependenciesTransformer(@Nullable String flavorName, @NotNull String variantName, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.flavorName = flavorName;
        this.variantName = variantName;
        this.project = project2;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_CONFS = kotlin.collections.CollectionsKt.listOf((Object[])new String[]{"api", "implementation", "compile", "compileOnly", "runtimeOnly"});
        DEFAULT_PROC_CONFS = kotlin.collections.CollectionsKt.listOf((Object[])new String[]{"kapt", "annotationProcessor"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/autonomousapps/internal/ConfigurationsToDependenciesTransformer$Companion;", "", "()V", "DEFAULT_CONFS", "", "", "DEFAULT_PROC_CONFS", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

