/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.ConfigurationsToDependenciesTransformer;
import com.autonomousapps.internal.DependencyConfiguration;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.LocateDependenciesTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/internal/ConfigurationsToDependenciesTransformer;", "", "flavorName", "", "variantName", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Ljava/lang/String;Lorg/gradle/api/Project;)V", "logger", "Lorg/gradle/api/logging/Logger;", "buildAPConfNames", "", "buildConfNames", "dependencyConfigurations", "Lcom/autonomousapps/internal/DependencyConfiguration;", "Companion", "dependency-analysis-gradle-plugin"})
public final class ConfigurationsToDependenciesTransformer {
    private final Logger logger;
    private final String flavorName;
    private final String variantName;
    private final Project project;
    private static final List<String> DEFAULT_CONFS;
    private static final List<String> DEFAULT_PROC_CONFS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DependencyConfiguration> dependencyConfigurations() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv232;
        boolean bl;
        Map.Entry entry;
        Map.Entry $dstr$name$_u24__u24;
        Map $this$filterTo$iv$iv;
        Set candidateConfNames = SetsKt.plus(this.buildConfNames(), (Iterable)this.buildAPConfNames());
        ConfigurationContainer configurationContainer = this.project.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
        SortedMap sortedMap = configurationContainer.getAsMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)sortedMap, (String)"project.configurations.asMap");
        Map $this$filter$iv = sortedMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry2;
            $dstr$name$_u24__u24 = entry2 = iterator.next();
            boolean bl3 = false;
            entry = $dstr$name$_u24__u24;
            bl = false;
            String name = (String)entry.getKey();
            if (!candidateConfNames.contains(name)) continue;
            destination$iv$iv.put(entry2.getKey(), entry2.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv232;
        bl2 = false;
        for (Map.Entry entry3 : object.entrySet()) {
            Configuration conf;
            void $dstr$_u24__u24$conf;
            $dstr$name$_u24__u24 = entry3;
            Object object2 = destination$iv$iv;
            boolean bl4 = false;
            entry = $dstr$_u24__u24$conf;
            bl = false;
            Configuration configuration = conf = (Configuration)entry.getValue();
            object2.add(configuration);
        }
        List interestingConfs = (List)destination$iv$iv;
        $i$f$map = false;
        LinkedHashMap<String, Set> warnings = new LinkedHashMap<String, Set>();
        boolean $this$mapTo$iv$iv232 = false;
        Map metadataSink = new LinkedHashMap();
        Iterable $this$flatMapToMutableSet$iv = interestingConfs;
        boolean $i$f$flatMapToMutableSet = false;
        object = $this$flatMapToMutableSet$iv;
        Collection destination$iv$iv2 = new HashSet(CollectionsKt.collectionSizeOrDefault($this$flatMapToMutableSet$iv, 10));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Configuration conf = (Configuration)element$iv$iv;
            boolean bl52 = false;
            Configuration configuration = conf;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
            DependencySet dependencySet = configuration.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"conf.dependencies");
            Iterable $this$map$iv2 = GradleStringsKt.toIdentifiers(dependencySet, metadataSink);
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void identifier;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl6 = false;
                String string2 = conf.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"conf.name");
                DependencyConfiguration dependencyConfiguration = new DependencyConfiguration((String)identifier, string2);
                boolean bl3 = false;
                boolean bl4 = false;
                DependencyConfiguration it = dependencyConfiguration;
                boolean bl9 = false;
                warnings.merge(it.getIdentifier(), SetsKt.mutableSetOf((Object[])new String[]{it.getConfigurationName()}), dependencyConfigurations.locations.1.1.1.1.INSTANCE);
                DependencyConfiguration dependencyConfiguration2 = dependencyConfiguration;
                collection.add(dependencyConfiguration2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set locations2 = (Set)destination$iv$iv2;
        Set set = warnings.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"warnings.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl5;
            void identifier;
            block9: {
                Object element$iv$iv;
                Map.Entry $dstr$identifier$configurations = (Map.Entry)element$iv;
                boolean bl6 = false;
                element$iv$iv = $dstr$identifier$configurations;
                boolean list$iv$iv = false;
                String bl52 = (String)element$iv$iv.getKey();
                element$iv$iv = $dstr$identifier$configurations;
                list$iv$iv = false;
                Set configurations = (Set)element$iv$iv.getValue();
                if (configurations.size() <= 1) continue;
                if (Intrinsics.areEqual((Object)((Boolean)metadataSink.get(identifier)), (Object)true) ^ true) {
                    this.logger.warn("Dependency " + (String)identifier + " has been declared multiple times: " + configurations);
                }
                Set set2 = configurations;
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"configurations");
                Iterable $this$any$iv = set2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl12 = false;
                        if (!StringsKt.endsWith((String)it, (String)"api", (boolean)true)) continue;
                        bl5 = true;
                        break block9;
                    }
                    bl5 = false;
                }
            }
            if (!bl5) continue;
            locations2.removeIf((Predicate)new Predicate<DependencyConfiguration>((String)identifier){
                final /* synthetic */ String $identifier;

                public final boolean test(@NotNull DependencyConfiguration it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getIdentifier(), (Object)this.$identifier) && !StringsKt.endsWith((String)it.getConfigurationName(), (String)"api", (boolean)true);
                }
                {
                    this.$identifier = string;
                }
            });
        }
        return locations2;
    }

    private final Set<String> buildConfNames() {
        String string;
        String it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = DEFAULT_CONFS;
        Collection collection2 = DEFAULT_CONFS;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = this.variantName + UtilsKt.capitalizeSafely$default(it, null, 1, null);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Set confNames = kotlin.collections.CollectionsKt.toMutableSet((Iterable)kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        if (this.flavorName != null) {
            $this$map$iv = DEFAULT_CONFS;
            collection2 = confNames;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = this.flavorName + UtilsKt.capitalizeSafely$default(it, null, 1, null);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            collection2.addAll(collection);
        }
        return confNames;
    }

    private final Set<String> buildAPConfNames() {
        String string;
        String it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = DEFAULT_PROC_CONFS;
        Collection collection2 = DEFAULT_PROC_CONFS;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it + UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Set procConfNames = kotlin.collections.CollectionsKt.toMutableSet((Iterable)kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        if (this.flavorName != null) {
            $this$map$iv = DEFAULT_PROC_CONFS;
            collection2 = procConfNames;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = it + UtilsKt.capitalizeSafely$default(this.flavorName, null, 1, null);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            collection2.addAll(collection);
        }
        return procConfNames;
    }

    public ConfigurationsToDependenciesTransformer(@Nullable String flavorName, @NotNull String variantName, @NotNull Project project2) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.flavorName = flavorName;
        this.variantName = variantName;
        this.project = project2;
        ConfigurationsToDependenciesTransformer configurationsToDependenciesTransformer = this;
        boolean $i$f$getLogger = false;
        Logger logger2 = Logging.getLogger(LocateDependenciesTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logging.getLogger(T::class.java)");
        configurationsToDependenciesTransformer.logger = logger = logger2;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_CONFS = kotlin.collections.CollectionsKt.listOf((Object[])new String[]{"api", "implementation", "compile", "compileOnly", "runtimeOnly"});
        DEFAULT_PROC_CONFS = kotlin.collections.CollectionsKt.listOf((Object[])new String[]{"kapt", "annotationProcessor"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/autonomousapps/internal/ConfigurationsToDependenciesTransformer$Companion;", "", "()V", "DEFAULT_CONFS", "", "", "DEFAULT_PROC_CONFS", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

