/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.advice.Dependency;
import com.autonomousapps.internal.AnalyzedClass;
import com.autonomousapps.internal.AnalyzedJar;
import com.autonomousapps.internal.Artifact;
import com.autonomousapps.internal.ClassNameAndAnnotationsVisitor;
import com.autonomousapps.internal.Component;
import com.autonomousapps.internal.JarAnalyzerKt;
import com.autonomousapps.internal.KtFile;
import com.autonomousapps.internal.asm.ClassReader;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.services.InMemoryCache;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/internal/JarAnalyzer;", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "artifacts", "", "Lcom/autonomousapps/internal/Artifact;", "logger", "Lorg/gradle/api/logging/Logger;", "inMemoryCache", "Lcom/autonomousapps/services/InMemoryCache;", "(Lorg/gradle/api/artifacts/Configuration;Ljava/util/List;Lorg/gradle/api/logging/Logger;Lcom/autonomousapps/services/InMemoryCache;)V", "analyzeJar", "Lcom/autonomousapps/internal/AnalyzedJar;", "artifact", "components", "Lcom/autonomousapps/internal/Component;", "computeTransitivity", "", "asComponents", "", "dependency-analysis-gradle-plugin"})
public final class JarAnalyzer {
    private final Configuration configuration;
    private final List<Artifact> artifacts;
    private final Logger logger;
    private final InMemoryCache inMemoryCache;

    @NotNull
    public final List<Component> components() {
        this.computeTransitivity();
        return this.asComponents((Iterable<Artifact>)this.artifacts);
    }

    /*
     * WARNING - void declaration
     */
    private final void computeTransitivity() {
        Set directDependencies = JarAnalyzerKt.access$directDependencies(this.configuration);
        Iterable $this$forEach$iv = this.artifacts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Artifact artifact;
            block4: {
                void $this$none$iv;
                Artifact artifact2 = (Artifact)element$iv;
                boolean bl2 = false;
                Iterable iterable = directDependencies;
                artifact = artifact2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        Dependency it = (Dependency)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)artifact2.getDependency())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            boolean bl4 = bl;
            artifact.setTransitive(bl4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Component> asComponents(@NotNull Iterable<Artifact> $this$asComponents) {
        void $this$mapTo$iv$iv;
        Iterable<Artifact> $this$map$iv = $this$asComponents;
        boolean $i$f$map = false;
        Iterable<Artifact> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void artifact;
            Artifact artifact2 = (Artifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnalyzedJar analyzedJar = this.analyzeJar((Artifact)artifact);
            Component component = new Component((Artifact)artifact, analyzedJar);
            collection.add(component);
        }
        return kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AnalyzedJar analyzeJar(Artifact artifact) {
        Iterable $this$filterNotTo$iv$iv;
        AnalyzedClass it;
        Object object;
        ClassNameAndAnnotationsVisitor classEntry;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ZipFile zip = new ZipFile(artifact.getFile());
        String string = zip.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zip.name");
        AnalyzedJar alreadyAnalyzedJar = this.inMemoryCache.analyzedJar$dependency_analysis_gradle_plugin(string);
        if (alreadyAnalyzedJar != null) {
            return alreadyAnalyzedJar;
        }
        String string2 = zip.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"zip.name");
        this.inMemoryCache.updateJars$dependency_analysis_gradle_plugin(string2);
        List<KtFile> ktFiles = KtFile.Companion.fromZip(zip);
        Iterable $this$map$iv = CollectionsKt.asClassFiles(zip);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ClassReader classReader;
            ZipEntry zipEntry = (ZipEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ClassNameAndAnnotationsVisitor classNameAndAnnotationsVisitor = new ClassNameAndAnnotationsVisitor(this.logger);
            boolean bl2 = false;
            boolean bl3 = false;
            ClassNameAndAnnotationsVisitor $this$apply = classNameAndAnnotationsVisitor;
            boolean bl4 = false;
            Closeable closeable = zip.getInputStream((ZipEntry)((Object)classEntry));
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                InputStream it2 = (InputStream)closeable;
                boolean bl6 = false;
                InputStream inputStream = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                classReader = new ClassReader(ByteStreamsKt.readBytes((InputStream)inputStream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ClassReader reader = classReader;
            reader.accept($this$apply, 0);
            object = classNameAndAnnotationsVisitor;
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            classEntry = (ClassNameAndAnnotationsVisitor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((ClassNameAndAnnotationsVisitor)((Object)it)).getAnalyzedClass$dependency_analysis_gradle_plugin();
            collection.add(object);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (AnalyzedClass)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it.getClassName(), (String)"java/", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapToOrderedSet$iv = (List)destination$iv$iv;
        boolean $i$f$mapToOrderedSet = false;
        $this$filterNotTo$iv$iv = $this$mapToOrderedSet$iv;
        destination$iv$iv = new TreeSet();
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AnalyzedClass)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = AnalyzedClass.copy$default(it, StringsKt.replace$default((String)it.getClassName(), (String)"/", (String)".", (boolean)false, (int)4, null), null, null, false, null, null, null, null, 254, null);
            collection.add(object);
        }
        Iterable $this$onEach$iv = (Set)destination$iv$iv;
        boolean $i$f$onEach = false;
        iterable = $this$onEach$iv;
        boolean destination$iv$iv2 = false;
        $i$f$mapTo = false;
        Iterable $this$apply$iv = iterable;
        boolean bl = false;
        for (Object element$iv : $this$apply$iv) {
            AnalyzedClass it3 = (AnalyzedClass)element$iv;
            boolean bl7 = false;
            this.inMemoryCache.updateClasses$dependency_analysis_gradle_plugin(it3.getClassName());
        }
        Set analyzedClasses = (Set)iterable;
        AnalyzedJar analyzedJar = new AnalyzedJar(analyzedClasses, ktFiles);
        boolean bl8 = false;
        boolean bl9 = false;
        AnalyzedJar it4 = analyzedJar;
        boolean bl10 = false;
        String string3 = zip.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"zip.name");
        this.inMemoryCache.analyzedJars$dependency_analysis_gradle_plugin(string3, it4);
        return analyzedJar;
    }

    public JarAnalyzer(@NotNull Configuration configuration, @NotNull List<Artifact> artifacts, @NotNull Logger logger, @NotNull InMemoryCache inMemoryCache2) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(artifacts, (String)"artifacts");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)inMemoryCache2, (String)"inMemoryCache");
        this.configuration = configuration;
        this.artifacts = artifacts;
        this.logger = logger;
        this.inMemoryCache = inMemoryCache2;
    }
}

