/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.GraphBuilder;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u00020\b8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/tasks/DependencyGraphTask;", "Lorg/gradle/api/DefaultTask;", "()V", "artifactFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getArtifactFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "setConfiguration", "(Lorg/gradle/api/artifacts/Configuration;)V", "outputDot", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputDot", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJson", "getOutputJson", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class DependencyGraphTask
extends DefaultTask {
    @NotNull
    public Configuration configuration;

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getArtifactFiles();

    @Internal
    @NotNull
    public final Configuration getConfiguration() {
        Configuration configuration = this.configuration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        }
        return configuration;
    }

    public final void setConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        this.configuration = configuration;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$toJson$iv;
        File outputJsonFile = UtilsKt.getAndDelete(this.getOutputJson());
        File outputDotFile = UtilsKt.getAndDelete(this.getOutputDot());
        Configuration configuration = this.configuration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        }
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"configuration.incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"configuration.incoming.resolutionResult");
        ResolvedComponentResult resolvedComponentResult = resolutionResult.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"configuration.incoming.resolutionResult.root");
        DependencyGraph graph = new GraphBuilder(resolvedComponentResult).buildGraph();
        this.getLogger().quiet("Graph JSON at " + outputJsonFile.getPath());
        DependencyGraph dependencyGraph = graph;
        File file = outputJsonFile;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        String string2 = string;
        FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
        this.getLogger().quiet("Graph DOT at " + outputDotFile.getPath());
        FilesKt.writeText$default((File)outputDotFile, (String)GraphWriter.INSTANCE.toDot(graph), null, (int)2, null);
    }

    public DependencyGraphTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Produces the dependency graph, for a given variant, for the current project");
    }
}

