/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.advice.Advice;
import com.autonomousapps.advice.ReasonableDependency;
import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.graph.ProducerNode;
import com.autonomousapps.graph.Reason;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\r\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/autonomousapps/tasks/ReasonTask;", "Lorg/gradle/api/DefaultTask;", "()V", "advice", "Lorg/gradle/api/file/RegularFileProperty;", "getAdvice", "()Lorg/gradle/api/file/RegularFileProperty;", "graph", "getGraph", "outputDot", "getOutputDot", "projectPath", "", "query", "reasonableDependencies", "", "Lcom/autonomousapps/advice/ReasonableDependency;", "getReasonableDependencies", "()Ljava/util/Set;", "reasonableDependencies$delegate", "Lkotlin/Lazy;", "reasonableDependenciesReport", "getReasonableDependenciesReport", "action", "", "getQueryNode", "Lcom/autonomousapps/graph/ProducerNode;", "identifier", "dependency-analysis-gradle-plugin"})
public abstract class ReasonTask
extends DefaultTask {
    private final String projectPath;
    private String query;
    private final Lazy reasonableDependencies$delegate;

    @Option(option="id", description="The dependency whose advice to explain")
    public final void query(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        this.query = identifier;
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getGraph();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAdvice();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getReasonableDependenciesReport();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    private final Set<ReasonableDependency> getReasonableDependencies() {
        Lazy lazy = this.reasonableDependencies$delegate;
        ReasonTask reasonTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Set)lazy.getValue();
    }

    @TaskAction
    public final void action() {
        File outputDot = UtilsKt.getAndDelete(this.getOutputDot());
        RegularFileProperty $this$fromJson$iv = this.getGraph();
        boolean $i$f$fromJson = false;
        Object object = $this$fromJson$iv.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"get()");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object;
        boolean $i$f$fromJson2 = false;
        File file = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"asFile");
        String $this$fromJson$iv$iv$iv = FilesKt.readText$default((File)file, null, (int)1, null);
        boolean $i$f$fromJson3 = false;
        boolean withNulls$iv$iv$iv$iv = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
        Object object2 = jsonAdapter.fromJson($this$fromJson$iv$iv$iv);
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        DependencyGraph graph = (DependencyGraph)object2;
        RegularFileProperty $this$fromJsonSet$iv = this.getAdvice();
        boolean $i$f$fromJsonSet = false;
        Object object3 = $this$fromJsonSet$iv.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"get()");
        RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object3;
        boolean $i$f$fromJsonSet2 = false;
        File file2 = $this$fromJsonSet$iv$iv.getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"asFile");
        String $this$fromJsonSet$iv$iv$iv = FilesKt.readText$default((File)file2, null, (int)1, null);
        boolean withNulls$iv$iv$iv = false;
        boolean $i$f$fromJsonSet3 = false;
        boolean $i$f$getJsonSetAdapter = false;
        ParameterizedType type$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)Advice.class)});
        JsonAdapter adapter$iv$iv$iv$iv2 = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv$iv);
        JsonAdapter jsonAdapter2 = adapter$iv$iv$iv$iv2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter2, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
        Object object4 = jsonAdapter2.fromJson($this$fromJsonSet$iv$iv$iv);
        if (object4 == null) {
            Intrinsics.throwNpe();
        }
        Set advice = (Set)object4;
        ProducerNode queryNode = this.getQueryNode();
        Reason reason = Reason.Companion.determine(graph, queryNode, advice);
        this.getLogger().quiet(reason.toString());
        this.getLogger().quiet("Reason DOT: " + outputDot.getPath());
        FilesKt.writeText$default((File)outputDot, (String)GraphWriter.INSTANCE.toDot(graph, reason.getPath()), null, (int)2, null);
    }

    private final ProducerNode getQueryNode() {
        Object v3;
        boolean bl;
        Object object;
        block7: {
            String string = this.query;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"query");
            }
            if (Intrinsics.areEqual((Object)string, (Object)this.projectPath)) {
                throw (Throwable)new GradleException("You cannot query for the project itself.");
            }
            object = this.getReasonableDependencies();
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                ReasonableDependency it = (ReasonableDependency)t;
                boolean bl3 = false;
                String string2 = it.getDependency().getIdentifier();
                String string3 = this.query;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"query");
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        ReasonableDependency reasonableDependency = v3;
        if (reasonableDependency == null) {
            StringBuilder stringBuilder = new StringBuilder().append("No component matching ");
            String string = this.query;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"query");
            }
            object = stringBuilder.append(string).append(" found in the dependency graph").toString();
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        ReasonableDependency reasonableDependency2 = reasonableDependency;
        String string = this.query;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"query");
        }
        return new ProducerNode(string, reasonableDependency2);
    }

    public ReasonTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Provides the reason for a piece of advice, for a given variant");
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String string = project2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.path");
        this.projectPath = string;
        this.reasonableDependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends ReasonableDependency>>(this){
            final /* synthetic */ ReasonTask this$0;

            @NotNull
            public final Set<ReasonableDependency> invoke() {
                RegularFileProperty $this$fromJsonSet$iv = this.this$0.getReasonableDependenciesReport();
                boolean $i$f$fromJsonSet = false;
                Object object = $this$fromJsonSet$iv.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"get()");
                RegularFile $this$fromJsonSet$iv$iv = (RegularFile)object;
                boolean $i$f$fromJsonSet2 = false;
                File file = $this$fromJsonSet$iv$iv.getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"asFile");
                String $this$fromJsonSet$iv$iv$iv = FilesKt.readText$default((File)file, null, (int)1, null);
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$fromJsonSet3 = false;
                boolean $i$f$getJsonSetAdapter = false;
                ParameterizedType type$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)ReasonableDependency.class)});
                JsonAdapter adapter$iv$iv$iv$iv = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv$iv);
                JsonAdapter jsonAdapter = adapter$iv$iv$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
                Object object2 = jsonAdapter.fromJson($this$fromJsonSet$iv$iv$iv);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                return (Set)object2;
            }
            {
                this.this$0 = reasonTask;
                super(0);
            }
        }));
    }
}

