/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.Edge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/autonomousapps/graph/GraphWriter;", "", "()V", "toDot", "", "graph", "Lcom/autonomousapps/graph/DependencyGraph;", "path", "", "Lcom/autonomousapps/graph/Edge;", "dependency-analysis-gradle-plugin"})
public final class GraphWriter {
    public static final GraphWriter INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toDot(@NotNull DependencyGraph graph2) {
        Intrinsics.checkParameterIsNotNull((Object)graph2, (String)"graph");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("strict digraph DependencyGraph {\n");
        Iterable $this$forEach$iv = graph2.edges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void from;
            Edge edge = (Edge)element$iv;
            boolean bl5 = false;
            Pair<String, String> pair = edge.nodeIds();
            String string = (String)pair.component1();
            String to = (String)pair.component2();
            $this$buildString.append("  \"" + (String)from + "\" -> \"" + to + "\";");
            $this$buildString.append("\n");
        }
        $this$buildString.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toDot(@NotNull Iterable<Edge> path) {
        Intrinsics.checkParameterIsNotNull(path, (String)"path");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("strict digraph DependencyGraph {\n");
        Iterable<Edge> $this$forEach$iv = path;
        boolean $i$f$forEach = false;
        Iterator<Edge> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void from;
            Edge element$iv;
            Edge edge = element$iv = iterator.next();
            boolean bl5 = false;
            Pair<String, String> pair = edge.nodeIds();
            String string = (String)pair.component1();
            String to = (String)pair.component2();
            $this$buildString.append("  \"" + (String)from + "\" -> \"" + to + "\";");
            $this$buildString.append("\n");
        }
        $this$buildString.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toDot(@NotNull DependencyGraph graph2, @NotNull Iterable<Edge> path) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)graph2, (String)"graph");
        Intrinsics.checkParameterIsNotNull(path, (String)"path");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        Iterable<Edge> $this$flatMap$iv = path;
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Edge it = (Edge)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = TuplesKt.toList(it.nodeIds());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List importantNodes = (List)destination$iv$iv;
        $this$buildString.append("strict digraph DependencyGraph {\n");
        Iterable $this$forEach$iv = importantNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl6 = false;
            $this$buildString.append("\n  \"" + it + "\" [style=filled fillcolor=\"#008080\"];\n");
        }
        $this$buildString.append("\n");
        $this$forEach$iv = graph2.edges();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void from;
            Edge edge = (Edge)element$iv;
            boolean bl7 = false;
            String style = CollectionsKt.contains(path, (Object)edge) ? " [style=bold color=\"#FF6347\" weight=8]" : "";
            Pair<String, String> pair = edge.nodeIds();
            String bl5 = (String)pair.component1();
            String to = (String)pair.component2();
            $this$buildString.append("  \"" + (String)from + "\" -> \"" + to + '\"' + style + ';');
            $this$buildString.append("\n");
        }
        $this$buildString.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private GraphWriter() {
    }

    static {
        GraphWriter graphWriter;
        INSTANCE = graphWriter = new GraphWriter();
    }
}

