/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.DependencyGraphKt;
import com.autonomousapps.graph.DepthFirstSearch;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.graph.Node;
import com.autonomousapps.graph.ProducerNode;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.ProjectGraphAggregationTask;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphAggregationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graphs", "Lorg/gradle/api/artifacts/Configuration;", "getGraphs", "()Lorg/gradle/api/artifacts/Configuration;", "setGraphs", "(Lorg/gradle/api/artifacts/Configuration;)V", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "outputRev", "getOutputRev", "outputRevSub", "getOutputRevSub", "query", "", "action", "", "getQueryNode", "Lcom/autonomousapps/graph/Node;", "identifier", "dependency-analysis-gradle-plugin"})
public abstract class ProjectGraphAggregationTask
extends DefaultTask {
    private String query;
    @NotNull
    public Configuration graphs;

    @Option(option="id", description="The project dependency for which to generate a reverse graph")
    public final void query(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        this.query = identifier;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final Configuration getGraphs() {
        Configuration configuration = this.graphs;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graphs");
        }
        return configuration;
    }

    public final void setGraphs(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        this.graphs = configuration;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputRev();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputRevSub();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$flatMapTo$iv$iv2;
        Iterable $this$filterIsInstanceTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        File outputRevFile = UtilsKt.getAndDelete(this.getOutputRev());
        File outputRevSubFile = UtilsKt.getAndDelete(this.getOutputRevSub());
        Configuration configuration = this.graphs;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graphs");
        }
        DependencySet dependencySet = configuration.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"graphs.dependencies");
        Iterable $this$filterIsInstance$iv = (Iterable)dependencySet;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProjectDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap22 = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$mapTo$iv$iv;
            ProjectDependency dep = (ProjectDependency)element$iv$iv;
            boolean bl = false;
            Configuration configuration2 = this.graphs;
            if (configuration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"graphs");
            }
            FileCollection fileCollection = configuration2.fileCollection(new Dependency[]{(Dependency)dep}).filter((Spec)action.graph.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"graphs.fileCollection(de\u2026  .filter { it.exists() }");
            Iterable $this$map$iv = (Iterable)fileCollection;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$fromJson$iv;
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                boolean $i$f$fromJson = false;
                String $this$fromJson$iv$iv = FilesKt.readText$default((File)$this$fromJson$iv, null, (int)1, null);
                boolean $i$f$fromJson2 = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonAdapter = false;
                JsonAdapter adapter$iv$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
                JsonAdapter jsonAdapter = adapter$iv$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
                Object object = jsonAdapter.fromJson($this$fromJson$iv$iv);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                DependencyGraph dependencyGraph = (DependencyGraph)object;
                collection.add(dependencyGraph);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        DependencyGraph graph2 = DependencyGraphKt.merge((List)destination$iv$iv);
        DependencyGraph reversed = graph2.reversed();
        this.getLogger().quiet("Graph DOT at " + outputFile.getPath());
        FilesKt.writeText$default((File)outputFile, (String)GraphWriter.INSTANCE.toDot(graph2), null, (int)2, null);
        this.getLogger().quiet("Graph rev DOT at " + outputRevFile.getPath());
        FilesKt.writeText$default((File)outputRevFile, (String)GraphWriter.INSTANCE.toDot(reversed), null, (int)2, null);
        CharSequence $i$f$flatMap22 = this.query;
        boolean $this$flatMapTo$iv$iv2 = false;
        if ($i$f$flatMap22.length() > 0) {
            Node node = this.getQueryNode();
            DependencyGraph subgraph2 = new DepthFirstSearch(reversed, node).getSubgraph();
            this.getLogger().quiet("Subgraph rooted on " + this.query + " at " + outputRevSubFile.getPath());
            FilesKt.writeText$default((File)outputRevSubFile, (String)GraphWriter.INSTANCE.toDot(subgraph2), null, (int)2, null);
        }
    }

    private final Node getQueryNode() {
        if (!StringsKt.startsWith$default((String)this.query, (String)":", (boolean)false, (int)2, null)) {
            throw (Throwable)new GradleException("You cannot query for a non-project dependency.");
        }
        return new ProducerNode(this.query, null, 2, null);
    }

    public ProjectGraphAggregationTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Produces a graph of all inter-project dependencies");
        this.query = "";
    }
}

