/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.Manifest;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.internal.utils.XmlKt;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J.\u0010\u000b\u001a \u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000f0\u000e0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u000f*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0014\u0010\u001b\u001a\u00020\r*\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/autonomousapps/tasks/ManifestPackageExtractionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "manifestArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "action", "", "extractManifestComponents", "Lkotlin/Pair;", "", "", "", "manifest", "Ljava/io/File;", "getManifestFiles", "Lorg/gradle/api/file/FileCollection;", "packageName", "document", "Lorg/w3c/dom/Document;", "setArtifacts", "componentNames", "component", "Lcom/autonomousapps/internal/Manifest$Component;", "withPackageName", "dependency-analysis-gradle-plugin"})
public abstract class ManifestPackageExtractionTask
extends DefaultTask {
    private ArtifactCollection manifestArtifacts;

    public final void setArtifacts(@NotNull ArtifactCollection manifestArtifacts) {
        Intrinsics.checkParameterIsNotNull((Object)manifestArtifacts, (String)"manifestArtifacts");
        this.manifestArtifacts = manifestArtifacts;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getManifestFiles() {
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"manifestArtifacts.artifactFiles");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$toJson$iv;
        void $this$mapNotNullTo$iv$iv;
        File outputFile = UtilsKt.getAndDelete(this.getOutput());
        ArtifactCollection artifactCollection = this.manifestArtifacts;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestArtifacts");
        }
        Iterable $this$mapNotNullToOrderedSet$iv = (Iterable)artifactCollection;
        boolean $i$f$mapNotNullToOrderedSet = false;
        Iterable iterable = $this$mapNotNullToOrderedSet$iv;
        Collection destination$iv$iv = new TreeSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<String, Map<String, Set<String>>> pair;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResolvedArtifactResult manifest = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            try {
                void pn;
                ResolvedArtifactResult resolvedArtifactResult = manifest;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"manifest");
                File file = resolvedArtifactResult.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"manifest.file");
                object = this.extractManifestComponents(file);
                boolean bl3 = false;
                boolean bl4 = false;
                Pair<String, Map<String, Set<String>>> $dstr$pn$componentMap = object;
                boolean bl5 = false;
                String string = (String)$dstr$pn$componentMap.component1();
                Map componentMap = (Map)$dstr$pn$componentMap.component2();
                ComponentArtifactIdentifier componentArtifactIdentifier = manifest.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"manifest.id");
                ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier, (String)"manifest.id.componentIdentifier");
                object = new Manifest((String)pn, (Map<String, ? extends Set<String>>)componentMap, componentIdentifier);
            }
            catch (GradleException _) {
                object = null;
            }
            if (object == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair<String, Map<String, Set<String>>> it$iv$iv = pair;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set manifests = (Set)destination$iv$iv;
        $this$mapNotNullToOrderedSet$iv = manifests;
        File file = outputFile;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(Set.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        String string2 = string;
        FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
    }

    private final Pair<String, Map<String, Set<String>>> extractManifestComponents(File manifest) {
        Document document = XmlKt.buildDocument(manifest);
        String pn = this.packageName(document);
        Set<String> services = this.componentNames(document, Manifest.Component.SERVICE, pn);
        Set<String> providers = this.componentNames(document, Manifest.Component.PROVIDER, pn);
        boolean bl = false;
        Map map = new LinkedHashMap();
        Collection collection = services;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            map.put(Manifest.Component.SERVICE.getMapKey(), services);
        }
        collection = providers;
        bl2 = false;
        if (!collection.isEmpty()) {
            map.put(Manifest.Component.PROVIDER.getMapKey(), providers);
        }
        return TuplesKt.to((Object)this.packageName(document), (Object)map);
    }

    private final String packageName(Document document) {
        Node node = document.getElementsByTagName("manifest").item(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"document.getElementsByTagName(\"manifest\").item(0)");
        Node node2 = node.getAttributes().getNamedItem("package");
        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"document.getElementsByTa\u2026 .getNamedItem(\"package\")");
        String string = node2.getNodeValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.getElementsByTa\u2026ackage\")\n      .nodeValue");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> componentNames(@NotNull Document $this$componentNames, Manifest.Component component, String packageName) {
        NodeList nodeList = $this$componentNames.getElementsByTagName(component.getTagName());
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"getElementsByTagName(component.tagName)");
        NodeList $this$mapToSet$iv = nodeList;
        boolean $i$f$mapToSet = false;
        HashSet<String> destination$iv = new HashSet<String>($this$mapToSet$iv.getLength());
        int n = 0;
        int n2 = $this$mapToSet$iv.getLength();
        while (n < n2) {
            void it;
            void i$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$mapToSet$iv.item((int)i$iv), (String)"item(i)");
            HashSet<String> hashSet = destination$iv;
            boolean bl = false;
            Node node = it.getAttributes().getNamedItem(component.getAttrName());
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"it.attributes.getNamedItem(component.attrName)");
            String string = node.getNodeValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.attributes.getNamedIt\u2026onent.attrName).nodeValue");
            String string2 = this.withPackageName(string, packageName);
            hashSet.add(string2);
            ++i$iv;
        }
        return destination$iv;
    }

    private final String withPackageName(@NotNull String $this$withPackageName, String packageName) {
        return StringsKt.startsWith$default((String)$this$withPackageName, (String)".", (boolean)false, (int)2, null) ? packageName + $this$withPackageName : $this$withPackageName;
    }

    public ManifestPackageExtractionTask() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of packages, from other components, that are included via Android manifests");
    }
}

