/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.ConsumerNode;
import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.Edge;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.graph.ProducerNode;
import com.autonomousapps.internal.Location;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "locations", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getLocations", "()Lorg/gradle/api/provider/ListProperty;", "outputDot", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputDot", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJson", "getOutputJson", "action", "", "Action", "Parameters", "dependency-analysis-gradle-plugin"})
public abstract class ProjectGraphTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getLocations();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(Action.class, (org.gradle.api.Action)new org.gradle.api.Action<Parameters>(this){
            final /* synthetic */ ProjectGraphTask this$0;

            public final void execute(@NotNull Parameters $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                $this$submit.getLocations().set((Provider)this.this$0.getLocations());
                $this$submit.getOutputJson().set((Provider)this.this$0.getOutputJson());
                $this$submit.getOutputDot().set((Provider)this.this$0.getOutputDot());
                Property<String> property = $this$submit.getProjectPath();
                Project project2 = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                property.set((Object)project2.getPath());
            }
            {
                this.this$0 = projectGraphTask;
            }
        });
    }

    @Inject
    public ProjectGraphTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a graph of all inter-project dependencies");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphTask$Parameters;", "Lorg/gradle/workers/WorkParameters;", "locations", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getLocations", "()Lorg/gradle/api/provider/ListProperty;", "outputDot", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputDot", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJson", "getOutputJson", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "dependency-analysis-gradle-plugin"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public ListProperty<RegularFile> getLocations();

        @NotNull
        public RegularFileProperty getOutputJson();

        @NotNull
        public RegularFileProperty getOutputDot();

        @NotNull
        public Property<String> getProjectPath();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphTask$Action;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ProjectGraphTask$Parameters;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "execute", "", "dependency-analysis-gradle-plugin"})
    public static abstract class Action
    implements WorkAction<Parameters> {
        private final Logger logger;

        /*
         * WARNING - void declaration
         */
        public void execute() {
            void $this$toJson$iv;
            Iterator $this$filterTo$iv$iv;
            Object it;
            Iterable $this$flatMapTo$iv$iv;
            File outputJsonFile = UtilsKt.getAndDelete(((Parameters)this.getParameters()).getOutputJson());
            File outputDotFile = UtilsKt.getAndDelete(((Parameters)this.getParameters()).getOutputDot());
            DependencyGraph graph2 = new DependencyGraph();
            Object object = ((Parameters)this.getParameters()).getLocations().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.locations.get()");
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RegularFile $this$fromJsonSet$iv;
                it = (RegularFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                boolean $i$f$fromJsonSet = false;
                File file = $this$fromJsonSet$iv.getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"asFile");
                String $this$fromJsonSet$iv$iv = FilesKt.readText$default((File)file, null, (int)1, null);
                boolean withNulls$iv$iv = false;
                boolean $i$f$fromJsonSet2 = false;
                boolean $i$f$getJsonSetAdapter = false;
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])new Type[]{(Type)((Object)Location.class)});
                JsonAdapter adapter$iv$iv$iv = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                JsonAdapter jsonAdapter = adapter$iv$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
                Object object2 = jsonAdapter.fromJson($this$fromJsonSet$iv$iv);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                Iterable list$iv$iv = (Set)object2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filterToSet$iv = (List)destination$iv$iv;
            boolean $i$f$filterToSet = false;
            $this$flatMapTo$iv$iv = $this$filterToSet$iv;
            destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                element$iv$iv = iterator.next();
                it = (Location)element$iv$iv;
                boolean bl = false;
                if (!(((Location)it).isInteresting() && StringsKt.startsWith$default((String)((Location)it).getIdentifier(), (String)":", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object $this$forEach$iv = (Set)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                Location it2 = (Location)element$iv;
                boolean bl = false;
                Object object3 = ((Parameters)this.getParameters()).getProjectPath().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.projectPath.get()");
                graph2.addEdge(new Edge(new ProducerNode((String)object3, null, 2, null), new ConsumerNode(it2.getIdentifier(), null, 2, null), 0, 4, null));
            }
            this.logger.quiet("Graph JSON at " + outputJsonFile.getPath());
            $this$forEach$iv = graph2;
            File file = outputJsonFile;
            boolean withNulls$iv = false;
            boolean $i$f$toJson = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
            JsonAdapter jsonAdapter = adapter$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"if (withNulls) {\n    ada\u2026 } else {\n    adapter\n  }");
            String string = jsonAdapter.toJson((Object)$this$toJson$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
            String string2 = string;
            FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
            this.logger.quiet("Graph DOT at " + outputDotFile.getPath());
            FilesKt.writeText$default((File)outputDotFile, (String)GraphWriter.INSTANCE.toDot(graph2), null, (int)2, null);
        }

        public Action() {
            Logger logger;
            Action action2 = this;
            boolean $i$f$getLogger = false;
            Logger logger2 = Logging.getLogger(ProjectGraphTask.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logging.getLogger(T::class.java)");
            action2.logger = logger = logger2;
        }
    }
}

