/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.advice.Advice;
import com.autonomousapps.graph.Change;
import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.Edge;
import com.autonomousapps.graph.Node;
import com.autonomousapps.graph.NodePrinter;
import com.autonomousapps.graph.PathPrinter;
import com.autonomousapps.graph.ProducerNode;
import com.autonomousapps.graph.Reason;
import com.autonomousapps.graph.ShortestPath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/graph/ChangeReason;", "Lcom/autonomousapps/graph/Reason;", "graph", "Lcom/autonomousapps/graph/DependencyGraph;", "queryNode", "Lcom/autonomousapps/graph/ProducerNode;", "advice", "Lcom/autonomousapps/advice/Advice;", "(Lcom/autonomousapps/graph/DependencyGraph;Lcom/autonomousapps/graph/ProducerNode;Lcom/autonomousapps/advice/Advice;)V", "adviceText", "", "coda", "infoText", "path", "", "Lcom/autonomousapps/graph/Edge;", "getPath", "()Ljava/lang/Iterable;", "pathText", "root", "Lcom/autonomousapps/graph/Node;", "sp", "Lcom/autonomousapps/graph/ShortestPath;", "toString", "dependency-analysis-gradle-plugin"})
final class ChangeReason
extends Reason {
    private final Node root;
    private final ShortestPath sp;
    @NotNull
    private final Iterable<Edge> path;
    private final String adviceText;
    private final String pathText;
    private final String infoText;
    private final String coda;

    @Override
    @NotNull
    public Iterable<Edge> getPath() {
        return this.path;
    }

    @NotNull
    public String toString() {
        return this.getHeaderText() + ' ' + this.adviceText + "\n\n" + this.pathText + '\n' + this.infoText + '\n' + this.coda;
    }

    public ChangeReason(@NotNull DependencyGraph graph, @NotNull ProducerNode queryNode, @NotNull Advice advice) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)queryNode, (String)"queryNode");
        Intrinsics.checkParameterIsNotNull((Object)advice, (String)"advice");
        super(queryNode, null);
        this.root = graph.getRootNode();
        this.sp = new ShortestPath(graph, this.root);
        Iterable<Edge> iterable = this.sp.pathTo(queryNode);
        if (iterable == null) {
            String string2 = "No path to node " + queryNode + ", violating invariant";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.path = iterable;
        this.adviceText = "You have been advised to change this dependency to " + advice.getToConfiguration() + " from " + advice.getFromConfiguration() + '.';
        this.pathText = PathPrinter.INSTANCE.printPath(this.getPath());
        this.infoText = NodePrinter.INSTANCE.print(queryNode);
        if (advice.isChange()) {
            String string3 = advice.getToConfiguration();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            string = Change.Companion.which(string3).getReason();
        } else if (advice.isCompileOnly()) {
            string = "And this dependency is only required during compilation.";
        } else {
            String string4 = "a change-reason must be either isChange or isCompileOnly";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        this.coda = string;
    }
}

