/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.DependencyGraphKt;
import com.autonomousapps.graph.Edge;
import com.autonomousapps.graph.Node;
import com.autonomousapps.graph.Topological;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/autonomousapps/graph/ShortestPath;", "", "graph", "Lcom/autonomousapps/graph/DependencyGraph;", "source", "Lcom/autonomousapps/graph/Node;", "(Lcom/autonomousapps/graph/DependencyGraph;Lcom/autonomousapps/graph/Node;)V", "distTo", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "edgeTo", "Lcom/autonomousapps/graph/Edge;", "other", "hasPathTo", "", "pathTo", "", "relax", "", "edge", "dependency-analysis-gradle-plugin"})
public final class ShortestPath {
    private final LinkedHashMap<String, Float> distTo;
    private final LinkedHashMap<String, Edge> edgeTo;

    public final float distTo(@NotNull Node other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Float f = this.distTo.get(other.getIdentifier());
        if (f == null) {
            Void void_ = DependencyGraphKt.missingNode(other);
            throw null;
        }
        return f.floatValue();
    }

    public final boolean hasPathTo(@NotNull Node other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.hasPathTo(other.getIdentifier());
    }

    public final boolean hasPathTo(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Float f = this.distTo.get(other);
        if (f == null) {
            Intrinsics.throwNpe();
        }
        return Float.compare(((Number)f).floatValue(), Integer.MAX_VALUE) < 0;
    }

    @Nullable
    public final Iterable<Edge> pathTo(@NotNull Node other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.pathTo(other.getIdentifier());
    }

    @Nullable
    public final Iterable<Edge> pathTo(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (!this.hasPathTo(other)) {
            return null;
        }
        Stack<Edge> path = new Stack<Edge>();
        Edge e = this.edgeTo.get(other);
        while (e != null) {
            path.push(e);
            e = this.edgeTo.get(e.getFrom().getIdentifier());
        }
        return path;
    }

    private final void relax(Edge edge) {
        Node v = edge.getFrom();
        Node w = edge.getTo();
        Float f = this.distTo.get(w.getIdentifier());
        if (f == null) {
            Intrinsics.throwNpe();
        }
        float f2 = ((Number)f).floatValue();
        Float f3 = this.distTo.get(v.getIdentifier());
        if (f3 == null) {
            Intrinsics.throwNpe();
        }
        if (f2 > ((Number)f3).floatValue() + (float)edge.getWeight()) {
            Map map = this.distTo;
            String string = w.getIdentifier();
            Float f4 = this.distTo.get(v.getIdentifier());
            if (f4 == null) {
                Intrinsics.throwNpe();
            }
            map.put(string, Float.valueOf(((Number)f4).floatValue() + (float)edge.getWeight()));
            ((Map)this.edgeTo).put(w.getIdentifier(), edge);
        }
    }

    public ShortestPath(@NotNull DependencyGraph graph, @NotNull Node source) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        boolean bl = false;
        this.distTo = new LinkedHashMap();
        bl = false;
        this.edgeTo = new LinkedHashMap();
        if (!graph.hasNode(source)) {
            Void void_ = DependencyGraphKt.missingNode(source);
            throw null;
        }
        for (Node node : graph.nodes()) {
            ((Map)this.distTo).put(node.getIdentifier(), Float.valueOf(Float.POSITIVE_INFINITY));
        }
        ((Map)this.distTo).put(source.getIdentifier(), Float.valueOf(0.0f));
        Topological top = new Topological(graph);
        for (String node : top.order()) {
            for (Edge edge : graph.adj(node)) {
                this.relax(edge);
            }
        }
    }
}

