/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.graph;

import com.autonomousapps.advice.Advice;
import com.autonomousapps.advice.ComprehensiveAdvice;
import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.internal.graph.Downgrade;
import com.autonomousapps.internal.graph.GraphMinimizer;
import com.autonomousapps.internal.graph.Impact;
import com.autonomousapps.internal.graph.ImpactedProjectGraph;
import com.autonomousapps.internal.graph.Upgrade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0014\u0010\u001f\u001a\u00020 *\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/autonomousapps/internal/graph/GraphMinimizer;", "", "buildHealth", "", "Lcom/autonomousapps/advice/ComprehensiveAdvice;", "dependentsGraph", "Lcom/autonomousapps/graph/DependencyGraph;", "lazyDepGraph", "Lkotlin/Function1;", "", "(Ljava/util/List;Lcom/autonomousapps/graph/DependencyGraph;Lkotlin/jvm/functions/Function1;)V", "affectedProjects", "", "Lcom/autonomousapps/internal/graph/ImpactedProjectGraph;", "downgradeMap", "", "Lcom/autonomousapps/internal/graph/Downgrade;", "hypotheticalGraphs", "minimalBuildHealth", "getMinimalBuildHealth", "()Ljava/util/List;", "upgradeMap", "Lcom/autonomousapps/internal/graph/Upgrade;", "compute", "computeAffectedProjects", "", "computeHypotheticalGraphs", "computeUpgradesAndDowngrades", "getDependencyGraph", "projectPath", "hypotheticalGraphFor", "hasAdviceNode", "", "advice", "Lcom/autonomousapps/advice/Advice;", "dependency-analysis-gradle-plugin"})
public final class GraphMinimizer {
    @NotNull
    private final List<ComprehensiveAdvice> minimalBuildHealth;
    private final Map<String, List<Downgrade>> downgradeMap;
    private final Map<String, List<Upgrade>> upgradeMap;
    private final Map<String, ImpactedProjectGraph> affectedProjects;
    private final Map<String, DependencyGraph> hypotheticalGraphs;
    private final List<ComprehensiveAdvice> buildHealth;
    private final DependencyGraph dependentsGraph;
    private final Function1<String, DependencyGraph> lazyDepGraph;

    @NotNull
    public final List<ComprehensiveAdvice> getMinimalBuildHealth() {
        return this.minimalBuildHealth;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ComprehensiveAdvice> compute() {
        void $this$mapTo$iv$iv;
        this.computeUpgradesAndDowngrades();
        this.computeAffectedProjects();
        this.computeHypotheticalGraphs();
        Iterable $this$map$iv = this.buildHealth;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void compAdvice2;
            ComprehensiveAdvice comprehensiveAdvice = (ComprehensiveAdvice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filterToSet$iv = compAdvice2.getDependencyAdvice();
            boolean $i$f$filterToSet = false;
            Iterable iterable2 = $this$filterToSet$iv;
            Collection destination$iv$iv2 = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Advice advice = (Advice)element$iv$iv;
                boolean bl2 = false;
                if (!(!advice.isAdd() ? true : (advice.isToApiLike() ? true : !this.hasAdviceNode(this.hypotheticalGraphFor(compAdvice2.getProjectPath()), advice)))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Set depAdvice = (Set)destination$iv$iv2;
            ComprehensiveAdvice comprehensiveAdvice2 = ComprehensiveAdvice.copy$default((ComprehensiveAdvice)compAdvice2, null, depAdvice, null, false, 13, null);
            collection.add(comprehensiveAdvice2);
        }
        return (List)destination$iv$iv;
    }

    private final void computeUpgradesAndDowngrades() {
        Iterable $this$forEach$iv = this.buildHealth;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComprehensiveAdvice compAdvice2 = (ComprehensiveAdvice)element$iv;
            boolean bl = false;
            String projectPath = compAdvice2.getProjectPath();
            Iterable $this$forEach$iv2 = compAdvice2.getDependencyAdvice();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Advice advice = (Advice)element$iv2;
                boolean bl2 = false;
                if (advice.isDowngrade()) {
                    this.downgradeMap.merge(projectPath, CollectionsKt.mutableListOf((Object[])new Downgrade[]{new Downgrade(advice, false, 2, null)}), computeUpgradesAndDowngrades.1.1.1.INSTANCE);
                    continue;
                }
                if (advice.isRemove()) {
                    this.downgradeMap.merge(projectPath, CollectionsKt.mutableListOf((Object[])new Downgrade[]{new Downgrade(advice, true)}), computeUpgradesAndDowngrades.1.1.2.INSTANCE);
                    continue;
                }
                if (!advice.isToApiLike()) continue;
                this.upgradeMap.merge(projectPath, CollectionsKt.mutableListOf((Object[])new Upgrade[]{new Upgrade(advice)}), computeUpgradesAndDowngrades.1.1.3.INSTANCE);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void computeAffectedProjects() {
        Map.Entry<String, List<Downgrade>> selfDowngrades;
        Upgrade upgrade;
        String projectPath;
        Object item$iv$iv;
        Map.Entry<String, List<Downgrade>> element$iv;
        Map<String, List<Impact>> $this$forEach$iv = this.downgradeMap;
        boolean $i$f$forEach = false;
        Map<String, List<Downgrade>> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, List<Downgrade>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object object;
            Iterator<String> $this$mapTo$iv$iv2;
            Object element$iv32;
            Map.Entry<String, List<Downgrade>> $dstr$projectPath$downgrades = element$iv = iterator.next();
            boolean bl2 = false;
            Object object2 = $dstr$projectPath$downgrades;
            boolean bl3 = false;
            String string = object2.getKey();
            object2 = $dstr$projectPath$downgrades;
            bl3 = false;
            List<Downgrade> downgrades = object2.getValue();
            Iterable $this$partition$iv = downgrades;
            boolean $i$f$partition = false;
            Iterable<Object> first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv32 : $this$partition$iv) {
                Downgrade it = (Downgrade)element$iv32;
                boolean bl4 = false;
                if (it.isSelfDowngrade()) {
                    first$iv.add(element$iv32);
                    continue;
                }
                second$iv.add(element$iv32);
            }
            Pair pair = new Pair(first$iv, second$iv);
            object2 = (List)pair.component1();
            List transDowngrades = (List)pair.component2();
            Iterable $this$mapToMutableList$iv = transDowngrades;
            boolean $i$f$mapToMutableList = false;
            first$iv = $this$mapToMutableList$iv;
            Collection destination$iv$iv = new ArrayList(com.autonomousapps.internal.utils.CollectionsKt.collectionSizeOrDefault($this$mapToMutableList$iv, 10));
            boolean $i$f$mapTo = false;
            element$iv32 = $this$mapTo$iv$iv2.iterator();
            while (element$iv32.hasNext()) {
                void it;
                item$iv$iv = element$iv32.next();
                Downgrade bl4 = (Downgrade)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                upgrade = TuplesKt.to((Object)projectPath, (Object)it.getId());
                object.add(upgrade);
            }
            List transEdgeRemovals = (List)destination$iv$iv;
            Iterable<String> $this$forEach$iv2 = this.dependentsGraph.subgraph(projectPath).projectNodes();
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                element$iv2 = $this$mapTo$iv$iv2.next();
                String projNode = element$iv2;
                boolean bl6 = false;
                this.affectedProjects.merge(projNode, new ImpactedProjectGraph(transEdgeRemovals, null, 2, null), computeAffectedProjects.1.2.1.INSTANCE);
            }
            Iterable $this$mapToMutableList$iv2 = (Iterable)((Object)selfDowngrades);
            boolean $i$f$mapToMutableList2 = false;
            element$iv2 = $this$mapToMutableList$iv2;
            Collection destination$iv$iv2 = new ArrayList(com.autonomousapps.internal.utils.CollectionsKt.collectionSizeOrDefault($this$mapToMutableList$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                Downgrade bl5 = (Downgrade)item$iv$iv2;
                object = destination$iv$iv2;
                boolean bl7 = false;
                upgrade = TuplesKt.to((Object)projectPath, (Object)it.getId());
                object.add(upgrade);
            }
            List selfEdgeRemovals = (List)destination$iv$iv2;
            this.affectedProjects.merge(projectPath, new ImpactedProjectGraph(selfEdgeRemovals, null, 2, null), computeAffectedProjects.1.3.INSTANCE);
        }
        $this$forEach$iv = this.upgradeMap;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Downgrade>> $dstr$projectPath$upgrades = element$iv = iterator.next();
            boolean bl8 = false;
            selfDowngrades = $dstr$projectPath$upgrades;
            boolean transDowngrades = false;
            projectPath = selfDowngrades.getKey();
            selfDowngrades = $dstr$projectPath$upgrades;
            transDowngrades = false;
            List<Downgrade> upgrades = selfDowngrades.getValue();
            Iterable<String> $this$forEach$iv3 = this.dependentsGraph.subgraph(projectPath).projectNodes();
            boolean $i$f$forEach3 = false;
            Iterator<String> iterator2 = $this$forEach$iv3.iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                String element$iv4;
                String projNode = element$iv4 = iterator2.next();
                boolean bl9 = false;
                Iterable $this$mapToMutableList$iv = upgrades;
                boolean $i$f$mapToMutableList = false;
                item$iv$iv = $this$mapToMutableList$iv;
                Collection destination$iv$iv = new ArrayList(com.autonomousapps.internal.utils.CollectionsKt.collectionSizeOrDefault($this$mapToMutableList$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                    void it;
                    upgrade = (Upgrade)item$iv$iv3;
                    Collection collection = destination$iv$iv;
                    boolean bl10 = false;
                    Pair pair = TuplesKt.to((Object)projectPath, (Object)it.getId());
                    collection.add(pair);
                }
                List upgradeEdges = (List)destination$iv$iv;
                this.affectedProjects.merge(projNode, new ImpactedProjectGraph(null, upgradeEdges, 1, null), computeAffectedProjects.2.1.1.INSTANCE);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void computeHypotheticalGraphs() {
        Map<String, ImpactedProjectGraph> $this$forEach$iv = this.affectedProjects;
        boolean $i$f$forEach = false;
        Map<String, ImpactedProjectGraph> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ImpactedProjectGraph>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void projectPath;
            Map.Entry<String, ImpactedProjectGraph> element$iv;
            Map.Entry<String, ImpactedProjectGraph> $dstr$projectPath$impactedGraph = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, ImpactedProjectGraph> entry = $dstr$projectPath$impactedGraph;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$projectPath$impactedGraph;
            bl3 = false;
            ImpactedProjectGraph impactedGraph = entry.getValue();
            List<Pair<String, String>> removableEdges = impactedGraph.getRemovals();
            List<Pair<String, String>> addableEdges = impactedGraph.getAdditions();
            DependencyGraph dependencyGraph = this.hypotheticalGraphFor((String)projectPath).removeEdges((String)projectPath, removableEdges);
            boolean bl4 = false;
            boolean bl5 = false;
            DependencyGraph $this$apply = dependencyGraph;
            boolean bl6 = false;
            $this$apply.addEdges(addableEdges);
            DependencyGraph graph = dependencyGraph;
            this.hypotheticalGraphs.put((String)projectPath, graph);
        }
    }

    private final DependencyGraph hypotheticalGraphFor(String projectPath) {
        DependencyGraph dependencyGraph = this.hypotheticalGraphs.get(projectPath);
        if (dependencyGraph == null) {
            dependencyGraph = this.getDependencyGraph(projectPath);
        }
        return dependencyGraph;
    }

    private final DependencyGraph getDependencyGraph(String projectPath) {
        return (DependencyGraph)this.lazyDepGraph.invoke((Object)projectPath);
    }

    private final boolean hasAdviceNode(DependencyGraph $this$hasAdviceNode, Advice advice) {
        return $this$hasAdviceNode.hasNode(advice.getDependency().getIdentifier());
    }

    public GraphMinimizer(@NotNull List<ComprehensiveAdvice> buildHealth, @NotNull DependencyGraph dependentsGraph, @NotNull Function1<? super String, DependencyGraph> lazyDepGraph2) {
        Intrinsics.checkParameterIsNotNull(buildHealth, (String)"buildHealth");
        Intrinsics.checkParameterIsNotNull((Object)dependentsGraph, (String)"dependentsGraph");
        Intrinsics.checkParameterIsNotNull(lazyDepGraph2, (String)"lazyDepGraph");
        this.buildHealth = buildHealth;
        this.dependentsGraph = dependentsGraph;
        this.lazyDepGraph = lazyDepGraph2;
        boolean bl = false;
        this.downgradeMap = new LinkedHashMap();
        bl = false;
        this.upgradeMap = new LinkedHashMap();
        bl = false;
        this.affectedProjects = new LinkedHashMap();
        bl = false;
        this.hypotheticalGraphs = new LinkedHashMap();
        this.minimalBuildHealth = this.compute();
    }
}

