/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.LoggingKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.ClassAnalysisTask;
import com.autonomousapps.tasks.ClassListAnalysisParameters;
import com.autonomousapps.tasks.ClassListAnalysisTask;
import com.autonomousapps.tasks.ClassListAnalysisWorkAction;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/autonomousapps/tasks/ClassListAnalysisTask;", "Lcom/autonomousapps/tasks/ClassAnalysisTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;)V", "javaClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJavaClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinClasses", "getKotlinClasses", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class ClassListAnalysisTask
extends ClassAnalysisTask {
    private final WorkerExecutor workerExecutor;

    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getKotlinClasses();

    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getJavaClasses();

    @TaskAction
    public final void action() {
        File reportFile = UtilsKt.getAndDelete(this.getOutput());
        File reportPrettyFile = UtilsKt.getAndDelete(this.getOutputPretty());
        FileCollection fileCollection = this.getJavaClasses().getAsFileTree().plus((FileCollection)this.getKotlinClasses());
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"javaClasses.asFileTree.plus(kotlinClasses)");
        Set set = com.autonomousapps.internal.utils.CollectionsKt.filterToClassFiles(fileCollection).getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"javaClasses.asFileTree.p\u2026ClassFiles()\n      .files");
        Set inputClassFiles = set;
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        Function1 function1 = action.1.INSTANCE;
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = null;
        CharSequence charSequence3 = "\n- ";
        CharSequence charSequence4 = "\n- ";
        LoggingKt.log(logger, "Java class files:" + CollectionsKt.joinToString$default((Iterable)((Iterable)this.getJavaClasses()), (CharSequence)charSequence3, (CharSequence)charSequence4, charSequence2, (int)n, charSequence, (Function1)function1, (int)28, null));
        Logger logger2 = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        function1 = action.2.INSTANCE;
        charSequence = null;
        n = 0;
        charSequence2 = null;
        charSequence3 = "\n- ";
        charSequence4 = "\n- ";
        LoggingKt.log(logger2, "Kotlin class files:" + CollectionsKt.joinToString$default((Iterable)((Iterable)this.getKotlinClasses()), (CharSequence)charSequence3, (CharSequence)charSequence4, charSequence2, (int)n, charSequence, (Function1)function1, (int)28, null));
        this.workerExecutor.noIsolation().submit(ClassListAnalysisWorkAction.class, (Action)new Action<ClassListAnalysisParameters>(this, inputClassFiles, reportFile, reportPrettyFile){
            final /* synthetic */ ClassListAnalysisTask this$0;
            final /* synthetic */ Set $inputClassFiles;
            final /* synthetic */ File $reportFile;
            final /* synthetic */ File $reportPrettyFile;

            public final void execute(@NotNull ClassListAnalysisParameters $this$submit) {
                Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                $this$submit.setClasses(this.$inputClassFiles);
                $this$submit.getVariantFiles().set((Provider)this.this$0.getVariantFiles());
                Set set = this.this$0.getLayoutFiles().getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"layoutFiles.files");
                $this$submit.setLayouts(set);
                $this$submit.setTestFiles(this.this$0.getTestFiles());
                $this$submit.setReport(this.$reportFile);
                $this$submit.setReportPretty(this.$reportPrettyFile);
            }
            {
                this.this$0 = classListAnalysisTask;
                this.$inputClassFiles = set;
                this.$reportFile = file;
                this.$reportPrettyFile = file2;
            }
        });
    }

    @Inject
    public ClassListAnalysisTask(@NotNull ObjectFactory objects, @NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        super(objects);
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces a report of all classes referenced by a given set of class files");
    }
}

