/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.DepthFirstSearch;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.graph.Node;
import com.autonomousapps.graph.ProducerNode;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0016H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/autonomousapps/tasks/DependencyGraphAllProjects;", "Lorg/gradle/api/DefaultTask;", "()V", "graphs", "Lorg/gradle/api/artifacts/Configuration;", "getGraphs", "()Lorg/gradle/api/artifacts/Configuration;", "setGraphs", "(Lorg/gradle/api/artifacts/Configuration;)V", "outputFullGraphDot", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFullGraphDot", "()Lorg/gradle/api/file/RegularFileProperty;", "outputFullGraphJson", "getOutputFullGraphJson", "outputRevGraphDot", "getOutputRevGraphDot", "outputRevGraphJson", "getOutputRevGraphJson", "outputRevSubGraphDot", "getOutputRevSubGraphDot", "query", "", "action", "", "getQueryNode", "Lcom/autonomousapps/graph/Node;", "identifier", "dependency-analysis-gradle-plugin"})
public abstract class DependencyGraphAllProjects
extends DefaultTask {
    private String query;
    public Configuration graphs;

    @Option(option="id", description="The project dependency for which to generate a reverse graph")
    public final void query(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        this.query = identifier;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final Configuration getGraphs() {
        Configuration configuration = this.graphs;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graphs");
        }
        return configuration;
    }

    public final void setGraphs(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        this.graphs = configuration;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFullGraphJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFullGraphDot();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputRevGraphJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputRevGraphDot();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputRevSubGraphDot();

    @TaskAction
    public final void action() {
        File outputFullGraphJsonFile = UtilsKt.getAndDelete(this.getOutputFullGraphJson());
        File outputDotFile = UtilsKt.getAndDelete(this.getOutputFullGraphDot());
        File outputRevJsonFile = UtilsKt.getAndDelete(this.getOutputRevGraphJson());
        File outputRevDotFile = UtilsKt.getAndDelete(this.getOutputRevGraphDot());
        File outputRevSubDotFile = UtilsKt.getAndDelete(this.getOutputRevSubGraphDot());
        Configuration configuration = this.graphs;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graphs");
        }
        DependencyGraph mergedGraph = com.autonomousapps.internal.graph.UtilsKt.mergedGraphFrom(configuration);
        DependencyGraph mergedReversedGraph = mergedGraph.reversed();
        Object $this$toJson$iv = mergedGraph;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"adapter");
        String string = jsonAdapter.toJson($this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)outputFullGraphJsonFile, (String)string, null, (int)2, null);
        $this$toJson$iv = mergedReversedGraph;
        withNulls$iv = false;
        $i$f$toJson = false;
        $i$f$getJsonAdapter = false;
        adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter2 = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter2, (String)"adapter");
        String string2 = jsonAdapter2.toJson($this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)outputRevJsonFile, (String)string2, null, (int)2, null);
        this.getLogger().debug("Graph DOT at " + outputDotFile.getPath());
        FilesKt.writeText$default((File)outputDotFile, (String)GraphWriter.INSTANCE.toDot(mergedGraph), null, (int)2, null);
        this.getLogger().debug("Graph rev DOT at " + outputRevDotFile.getPath());
        FilesKt.writeText$default((File)outputRevDotFile, (String)GraphWriter.INSTANCE.toDot(mergedReversedGraph), null, (int)2, null);
        $this$toJson$iv = this.query;
        withNulls$iv = false;
        if ($this$toJson$iv.length() > 0) {
            Node node = this.getQueryNode();
            DependencyGraph subgraph2 = new DepthFirstSearch(mergedReversedGraph, node).getSubgraph();
            this.getLogger().quiet("Subgraph rooted on " + this.query + " at " + outputRevSubDotFile.getPath());
            FilesKt.writeText$default((File)outputRevSubDotFile, (String)GraphWriter.INSTANCE.toDot(subgraph2), null, (int)2, null);
        }
    }

    private final Node getQueryNode() {
        if (!StringsKt.startsWith$default((String)this.query, (String)":", (boolean)false, (int)2, null)) {
            throw (Throwable)new GradleException("You cannot query for a non-project dependency.");
        }
        return new ProducerNode(this.query, null, 2, null);
    }

    public DependencyGraphAllProjects() {
        this.setGroup("dependency-analysis");
        this.setDescription("Produces a graph of all inter-project dependencies");
        this.query = "";
    }
}

