/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.GraphWriter;
import com.autonomousapps.internal.utils.LoggingKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.tasks.DependencyGraphWalker;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/autonomousapps/tasks/DependencyGraphPerVariant;", "Lorg/gradle/api/DefaultTask;", "()V", "compileClasspath", "Lorg/gradle/api/artifacts/Configuration;", "getCompileClasspath", "()Lorg/gradle/api/artifacts/Configuration;", "setCompileClasspath", "(Lorg/gradle/api/artifacts/Configuration;)V", "compileClasspathArtifacts", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompileClasspathArtifacts", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDot", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputDot", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJson", "getOutputJson", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class DependencyGraphPerVariant
extends DefaultTask {
    public Configuration compileClasspath;

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getCompileClasspathArtifacts();

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Internal
    @NotNull
    public final Configuration getCompileClasspath() {
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        return configuration;
    }

    public final void setCompileClasspath(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        this.compileClasspath = configuration;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputDot();

    @TaskAction
    public final void action() {
        File outputJsonFile = UtilsKt.getAndDelete(this.getOutputJson());
        File outputDotFile = UtilsKt.getAndDelete(this.getOutputDot());
        Configuration configuration = this.compileClasspath;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compileClasspath");
        }
        DependencyGraph graph = new DependencyGraphWalker(configuration).getGraph();
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        LoggingKt.log(logger, "Graph JSON at " + outputJsonFile.getPath());
        DependencyGraph $this$toJson$iv = graph;
        boolean withNulls$iv = false;
        boolean $i$f$toJson = false;
        boolean $i$f$getJsonAdapter = false;
        JsonAdapter adapter$iv$iv = MoshiUtils.getMOSHI().adapter(DependencyGraph.class);
        JsonAdapter jsonAdapter = adapter$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"adapter");
        String string = jsonAdapter.toJson((Object)$this$toJson$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getJsonAdapter<T>(withNulls).toJson(this)");
        FilesKt.writeText$default((File)outputJsonFile, (String)string, null, (int)2, null);
        Logger logger2 = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        LoggingKt.log(logger2, "Graph DOT at " + outputDotFile.getPath());
        FilesKt.writeText$default((File)outputDotFile, (String)GraphWriter.INSTANCE.toDot(graph), null, (int)2, null);
    }

    public DependencyGraphPerVariant() {
        this.setGroup("dependency-analysis-internal");
        this.setDescription("Produces the dependency graph, for a given variant, for the current project");
    }
}

