/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.Manifest;
import com.autonomousapps.internal.utils.XmlKt;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0011\u001a\u00020\b*\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/internal/ManifestParser;", "", "()V", "application", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "packageName", "", "parse", "Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "manifest", "Ljava/io/File;", "componentNames", "", "component", "Lcom/autonomousapps/internal/Manifest$Component;", "withPackageName", "ParseResult", "dependency-analysis-gradle-plugin"})
public final class ManifestParser {
    @NotNull
    public final ParseResult parse(@NotNull File manifest) {
        Set<String> set;
        Set<String> services;
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        Document document = XmlKt.buildDocument(manifest);
        String packageName = this.packageName(document);
        Element application = this.application(document);
        Object object = application;
        if (object == null || (object = this.componentNames((Element)object, Manifest.Component.SERVICE, packageName)) == null) {
            object = services = SetsKt.emptySet();
        }
        if ((set = application) == null || (set = this.componentNames((Element)((Object)set), Manifest.Component.PROVIDER, packageName)) == null) {
            set = SetsKt.emptySet();
        }
        Set<String> providers = set;
        boolean bl = false;
        Map componentsMapping = new LinkedHashMap();
        Collection collection = services;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            componentsMapping.put(Manifest.Component.SERVICE.getMapKey(), services);
        }
        collection = providers;
        bl2 = false;
        if (!collection.isEmpty()) {
            componentsMapping.put(Manifest.Component.PROVIDER.getMapKey(), providers);
        }
        return new ParseResult(packageName, componentsMapping);
    }

    private final Element application(Document document) {
        Element element;
        NodeList elements;
        NodeList nodeList = elements = document.getElementsByTagName("application");
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"elements");
        if (nodeList.getLength() > 0) {
            Node node = elements.item(0);
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            element = (Element)node;
        } else {
            element = null;
        }
        return element;
    }

    private final String packageName(Document document) {
        Node node = document.getElementsByTagName("manifest").item(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"document.getElementsByTagName(\"manifest\").item(0)");
        Node node2 = node.getAttributes().getNamedItem("package");
        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"document.getElementsByTa\u2026 .getNamedItem(\"package\")");
        String string = node2.getNodeValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.getElementsByTa\u2026ackage\")\n      .nodeValue");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> componentNames(Element $this$componentNames, Manifest.Component component, String packageName) {
        NodeList nodeList = $this$componentNames.getElementsByTagName(component.getTagName());
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"getElementsByTagName(component.tagName)");
        NodeList $this$mapToSet$iv = nodeList;
        boolean $i$f$mapToSet = false;
        HashSet<String> destination$iv = new HashSet<String>($this$mapToSet$iv.getLength());
        int n = 0;
        int n2 = $this$mapToSet$iv.getLength();
        while (n < n2) {
            void it;
            void i$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$mapToSet$iv.item((int)i$iv), (String)"item(i)");
            HashSet<String> hashSet = destination$iv;
            boolean bl = false;
            Node node = it.getAttributes().getNamedItem(component.getAttrName());
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"it.attributes.getNamedItem(component.attrName)");
            String string = node.getNodeValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.attributes.getNamedIt\u2026onent.attrName).nodeValue");
            String string2 = this.withPackageName(string, packageName);
            hashSet.add(string2);
            ++i$iv;
        }
        return destination$iv;
    }

    private final String withPackageName(String $this$withPackageName, String packageName) {
        return StringsKt.startsWith$default((String)$this$withPackageName, (String)".", (boolean)false, (int)2, null) ? packageName + $this$withPackageName : $this$withPackageName;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/internal/ManifestParser$ParseResult;", "", "packageName", "", "components", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getComponents", "()Ljava/util/Map;", "getPackageName", "()Ljava/lang/String;", "dependency-analysis-gradle-plugin"})
    public static final class ParseResult {
        @NotNull
        private final String packageName;
        @NotNull
        private final Map<String, Set<String>> components;

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final Map<String, Set<String>> getComponents() {
            return this.components;
        }

        public ParseResult(@NotNull String packageName, @NotNull Map<String, ? extends Set<String>> components) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull(components, (String)"components");
            this.packageName = packageName;
            this.components = components;
        }
    }
}

