/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.ibm.icu.impl.number;

import java.math.BigDecimal;
import shadow.com.ibm.icu.impl.number.DecimalQuantity;
import shadow.com.ibm.icu.impl.number.MicroProps;
import shadow.com.ibm.icu.impl.number.MicroPropsGenerator;

public class MultiplierImpl
implements MicroPropsGenerator {
    final int magnitudeMultiplier;
    final BigDecimal bigDecimalMultiplier;
    final MicroPropsGenerator parent;

    public MultiplierImpl(int magnitudeMultiplier) {
        this.magnitudeMultiplier = magnitudeMultiplier;
        this.bigDecimalMultiplier = null;
        this.parent = null;
    }

    public MultiplierImpl(BigDecimal bigDecimalMultiplier) {
        this.magnitudeMultiplier = 0;
        this.bigDecimalMultiplier = bigDecimalMultiplier;
        this.parent = null;
    }

    private MultiplierImpl(MultiplierImpl base, MicroPropsGenerator parent) {
        this.magnitudeMultiplier = base.magnitudeMultiplier;
        this.bigDecimalMultiplier = base.bigDecimalMultiplier;
        this.parent = parent;
    }

    public MicroPropsGenerator copyAndChain(MicroPropsGenerator parent) {
        return new MultiplierImpl(this, parent);
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.parent.processQuantity(quantity);
        quantity.adjustMagnitude(this.magnitudeMultiplier);
        if (this.bigDecimalMultiplier != null) {
            quantity.multiplyBy(this.bigDecimalMultiplier);
        }
        return micros;
    }
}

