/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.ibm.icu.text;

import java.text.ParsePosition;
import java.util.HashMap;
import shadow.com.ibm.icu.lang.UCharacter;
import shadow.com.ibm.icu.text.RBBINode;
import shadow.com.ibm.icu.text.RBBIRuleScanner;
import shadow.com.ibm.icu.text.SymbolTable;
import shadow.com.ibm.icu.text.UTF16;
import shadow.com.ibm.icu.text.UnicodeMatcher;
import shadow.com.ibm.icu.text.UnicodeSet;

class RBBISymbolTable
implements SymbolTable {
    HashMap<String, RBBISymbolTableEntry> fHashTable;
    RBBIRuleScanner fRuleScanner;
    String ffffString;
    UnicodeSet fCachedSetLookup;

    RBBISymbolTable(RBBIRuleScanner rs) {
        this.fRuleScanner = rs;
        this.fHashTable = new HashMap();
        this.ffffString = "\uffff";
    }

    @Override
    public char[] lookup(String s) {
        String retString;
        RBBISymbolTableEntry el = this.fHashTable.get(s);
        if (el == null) {
            return null;
        }
        RBBINode varRefNode = el.val;
        while (varRefNode.fLeftChild.fType == 2) {
            varRefNode = varRefNode.fLeftChild;
        }
        RBBINode exprNode = varRefNode.fLeftChild;
        if (exprNode.fType == 0) {
            RBBINode usetNode = exprNode.fLeftChild;
            this.fCachedSetLookup = usetNode.fInputSet;
            retString = this.ffffString;
        } else {
            this.fRuleScanner.error(66063);
            retString = exprNode.fText;
            this.fCachedSetLookup = null;
        }
        return retString.toCharArray();
    }

    @Override
    public UnicodeMatcher lookupMatcher(int ch) {
        UnicodeSet retVal = null;
        if (ch == 65535) {
            retVal = this.fCachedSetLookup;
            this.fCachedSetLookup = null;
        }
        return retVal;
    }

    @Override
    public String parseReference(String text, ParsePosition pos, int limit) {
        int start;
        int i2;
        int c;
        String result = "";
        for (i2 = start = pos.getIndex(); i2 < limit; i2 += UTF16.getCharCount(c)) {
            c = UTF16.charAt(text, i2);
            if (i2 == start && !UCharacter.isUnicodeIdentifierStart(c) || !UCharacter.isUnicodeIdentifierPart(c)) break;
        }
        if (i2 == start) {
            return result;
        }
        pos.setIndex(i2);
        result = text.substring(start, i2);
        return result;
    }

    RBBINode lookupNode(String key) {
        RBBINode retNode = null;
        RBBISymbolTableEntry el = this.fHashTable.get(key);
        if (el != null) {
            retNode = el.val;
        }
        return retNode;
    }

    void addEntry(String key, RBBINode val) {
        RBBISymbolTableEntry e = this.fHashTable.get(key);
        if (e != null) {
            this.fRuleScanner.error(66055);
            return;
        }
        e = new RBBISymbolTableEntry();
        e.key = key;
        e.val = val;
        this.fHashTable.put(e.key, e);
    }

    void rbbiSymtablePrint() {
        RBBISymbolTableEntry s;
        int i2;
        System.out.print("Variable Definitions\nName               Node Val     String Val\n----------------------------------------------------------------------\n");
        RBBISymbolTableEntry[] syms = this.fHashTable.values().toArray(new RBBISymbolTableEntry[0]);
        for (i2 = 0; i2 < syms.length; ++i2) {
            s = syms[i2];
            System.out.print("  " + s.key + "  ");
            System.out.print("  " + s.val + "  ");
            System.out.print(s.val.fLeftChild.fText);
            System.out.print("\n");
        }
        System.out.println("\nParsed Variable Definitions\n");
        for (i2 = 0; i2 < syms.length; ++i2) {
            s = syms[i2];
            System.out.print(s.key);
            s.val.fLeftChild.printTree(true);
            System.out.print("\n");
        }
    }

    static class RBBISymbolTableEntry {
        String key;
        RBBINode val;

        RBBISymbolTableEntry() {
        }
    }
}

