/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.BareNode;
import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.DependencyGraphKt;
import com.autonomousapps.graph.DepthFirstSearch;
import com.autonomousapps.graph.Edge;
import com.autonomousapps.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J \u0010\u0018\u001a\u00020\u00142\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001b0\u001aJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0005J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u0016\u001a\u00020\rJ\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010#\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\rJ\u000e\u0010#\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010$\u001a\u00020\nH\u0016J\u0006\u0010%\u001a\u00020\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u001eJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eJ\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J(\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00052\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001b0\u001aJ\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010,\u001a\u00020\u0005H\u0016R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006."}, d2={"Lcom/autonomousapps/graph/DependencyGraph;", "", "()V", "adj", "Ljava/util/LinkedHashMap;", "", "", "Lcom/autonomousapps/graph/Edge;", "Lkotlin/collections/LinkedHashMap;", "edgeCount", "", "inDegree", "nodes", "Lcom/autonomousapps/graph/Node;", "rootNode", "getRootNode", "()Lcom/autonomousapps/graph/Node;", "rootNode$delegate", "Lkotlin/Lazy;", "addEdge", "", "edge", "from", "to", "addEdges", "edges", "", "Lkotlin/Pair;", "addNode", "node", "", "copy", "equals", "", "other", "hasNode", "hashCode", "nodeCount", "projectNodes", "removeEdge", "removeEdges", "root", "reversed", "subgraph", "toString", "Companion", "dependency-analysis-gradle-plugin"})
public final class DependencyGraph {
    private final LinkedHashMap<String, Set<Edge>> adj = new LinkedHashMap();
    private final LinkedHashMap<String, Node> nodes = new LinkedHashMap();
    private final LinkedHashMap<String, Integer> inDegree = new LinkedHashMap();
    private int edgeCount;
    @NotNull
    private final Lazy rootNode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Node>(this){
        final /* synthetic */ DependencyGraph this$0;

        @NotNull
        public final Node invoke() {
            Object object;
            Object v2;
            boolean bl;
            Object object2;
            block3: {
                Set<Map.Entry<K, V>> set = DependencyGraph.access$getInDegree$p(this.this$0).entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"inDegree.entries");
                object2 = set;
                bl = false;
                Iterable iterable = object2;
                boolean bl2 = false;
                for (T t : iterable) {
                    Integer inDegree;
                    Map.Entry $dstr$_u24__u24$inDegree = (Map.Entry)t;
                    boolean bl3 = false;
                    Map.Entry entry = $dstr$_u24__u24$inDegree;
                    boolean bl4 = false;
                    Integer n = inDegree = (Integer)entry.getValue();
                    if (!(n != null && n == 0)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            if ((object = (Map.Entry)v2) == null || (object = (String)object.getKey()) == null) {
                object2 = "could not find root node";
                bl = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inDegree.entries.find { \u2026ould not find root node\")");
            Object root = object;
            Node node = (Node)DependencyGraph.access$getNodes$p(this.this$0).get(root);
            if (node == null) {
                Void void_ = DependencyGraphKt.missingNode((String)root);
                throw null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"nodes[root] ?: missingNode(root)");
            return node;
        }
        {
            this.this$0 = dependencyGraph;
            super(0);
        }
    }));
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void addEdge(@NotNull String from, @NotNull String to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.addEdge(new Edge(new BareNode(from), new BareNode(to), 0, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void addEdge(@NotNull Edge edge) {
        void added;
        Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        this.adj.merge(edge.getFrom().getIdentifier(), SetsKt.mutableSetOf((Object[])new Edge[]{edge}), new BiFunction<Set<Edge>, Set<Edge>, Set<Edge>>((Ref.BooleanRef)added){
            final /* synthetic */ Ref.BooleanRef $added;

            @Nullable
            public final Set<Edge> apply(@NotNull Set<Edge> set, @NotNull Set<Edge> increment) {
                Intrinsics.checkParameterIsNotNull(set, (String)"set");
                Intrinsics.checkParameterIsNotNull(increment, (String)"increment");
                Set<Edge> set2 = set;
                boolean bl = false;
                boolean bl2 = false;
                Set<Edge> $this$apply = set2;
                boolean bl3 = false;
                this.$added.element = $this$apply.addAll((Collection<Edge>)increment);
                return set2;
            }
            {
                this.$added = booleanRef;
            }
        });
        if (added.element) {
            this.inDegree.merge(edge.getTo().getIdentifier(), 1, addEdge.2.INSTANCE);
            int n = this.edgeCount;
            this.edgeCount = n + 1;
        }
        this.addNode(edge.getTo());
        this.addNode(edge.getFrom());
    }

    public final void addEdges(@NotNull List<Pair<String, String>> edges) {
        Intrinsics.checkParameterIsNotNull(edges, (String)"edges");
        Iterable $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.addEdge((String)it.getFirst(), (String)it.getSecond());
        }
    }

    public final void addNode(@NotNull String node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.addNode(new BareNode(node));
    }

    public final void addNode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.adj.computeIfAbsent(node.getIdentifier(), addNode.1.INSTANCE);
        this.nodes.computeIfAbsent(node.getIdentifier(), new Function<String, Node>(node){
            final /* synthetic */ Node $node;

            @NotNull
            public final Node apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$node;
            }
            {
                this.$node = node;
            }
        });
        this.inDegree.computeIfAbsent(node.getIdentifier(), addNode.3.INSTANCE);
    }

    @NotNull
    public final Node getRootNode() {
        Lazy lazy = this.rootNode$delegate;
        DependencyGraph dependencyGraph = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Node)lazy.getValue();
    }

    public final int nodeCount() {
        return this.adj.size();
    }

    public final int edgeCount() {
        return this.edgeCount;
    }

    @NotNull
    public final Iterable<Edge> adj(@NotNull Node from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.adj(from.getIdentifier());
    }

    @NotNull
    public final Iterable<Edge> adj(@NotNull String from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Set<Edge> set = this.adj.get(from);
        if (set == null) {
            Void void_ = DependencyGraphKt.missingNode(from);
            throw null;
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Edge> edges() {
        void $this$flatMapTo$iv$iv;
        Map $this$flatMap$iv = this.nodes;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$node = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$_u24__u24$node;
            boolean bl3 = false;
            Node node = (Node)entry.getValue();
            Iterable<Edge> list$iv$iv = this.adj(node);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<Node> nodes() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.nodes;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            Node node;
            void $dstr$_u24__u24$node;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_12 = $dstr$_u24__u24$node;
            boolean bl3 = false;
            Node node2 = node = (Node)var12_12.getValue();
            collection.add(node2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<String> projectNodes() {
        void $this$mapNotNullTo$iv$iv;
        Iterable<Node> $this$mapNotNull$iv = this.nodes();
        boolean $i$f$mapNotNull = false;
        Iterable<Node> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Node it = (Node)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getIdentifier();
            boolean bl3 = false;
            boolean bl4 = false;
            String $this$run = string2;
            boolean bl5 = false;
            if ((StringsKt.startsWith$default((String)$this$run, (String)":", (boolean)false, (int)2, null) ? $this$run : null) == null) continue;
            string = string;
            boolean bl6 = false;
            boolean bl7 = false;
            String it$iv$iv = string;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasNode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.hasNode(node.getIdentifier());
    }

    public final boolean hasNode(@NotNull String node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.nodes.get(node) != null;
    }

    @NotNull
    public final DependencyGraph copy() {
        return Companion.newGraph((Iterable<Edge>)this.edges());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DependencyGraph reversed() {
        DependencyGraph reversed = new DependencyGraph();
        Map $this$forEach$iv = this.adj;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void node;
            Map.Entry element$iv;
            Map.Entry $dstr$node$edges = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$node$edges;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$node$edges;
            bl3 = false;
            Set edges = (Set)entry.getValue();
            Iterable $this$forEach$iv2 = edges;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Edge edge = (Edge)element$iv2;
                boolean bl4 = false;
                reversed.addEdge(new Edge(edge.getTo(), edge.getFrom(), edge.getWeight()));
            }
            reversed.addNode((String)node);
        }
        return reversed;
    }

    @NotNull
    public final DependencyGraph subgraph(@NotNull String node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return new DepthFirstSearch(this, node).getSubgraph();
    }

    @NotNull
    public final DependencyGraph removeEdge(@NotNull String from, @NotNull String to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        DependencyGraph graph = new DependencyGraph();
        Iterable $this$forEach$iv = this.edges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge edge = (Edge)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)edge.getFrom().getIdentifier(), (Object)from) && Intrinsics.areEqual((Object)edge.getTo().getIdentifier(), (Object)to)) continue;
            graph.addEdge(edge);
        }
        graph.addNode(from);
        graph.addNode(to);
        return graph;
    }

    @NotNull
    public final DependencyGraph removeEdges(@NotNull String root, @NotNull List<Pair<String, String>> edges) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(edges, (String)"edges");
        if (edges.isEmpty()) {
            return this.copy();
        }
        DependencyGraph graph = new DependencyGraph();
        Object $this$forEach$iv = this.edges();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            Edge edge = (Edge)element$iv;
            boolean bl = false;
            if (!edges.contains(TuplesKt.to((Object)edge.getFrom().getIdentifier(), (Object)edge.getTo().getIdentifier()))) {
                graph.addEdge(edge);
                continue;
            }
            graph.addNode(edge.getFrom().getIdentifier());
            graph.addNode(edge.getTo().getIdentifier());
        }
        $this$forEach$iv = this.nodes;
        $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$id$_u24__u24 = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$id$_u24__u24;
            boolean bl3 = false;
            String id = (String)entry.getKey();
            graph.addNode(id);
        }
        return graph.subgraph(root);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.edges(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.autonomousapps.graph.DependencyGraph");
        }
        DependencyGraph cfr_ignored_0 = (DependencyGraph)object2;
        if (Intrinsics.areEqual((Object)CollectionsKt.sorted((Iterable)this.edges()), (Object)CollectionsKt.sorted((Iterable)((DependencyGraph)other).edges())) ^ true) {
            return false;
        }
        Set<String> set = this.nodes.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"nodes.keys");
        List list = CollectionsKt.sorted((Iterable)set);
        Set<String> set2 = ((DependencyGraph)other).nodes.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"other.nodes.keys");
        return !(Intrinsics.areEqual((Object)list, (Object)CollectionsKt.sorted((Iterable)set2)) ^ true);
    }

    public int hashCode() {
        int result = ((Object)this.edges()).hashCode();
        result = 31 * result + ((Object)this.nodes.keySet()).hashCode();
        return result;
    }

    public static final /* synthetic */ LinkedHashMap access$getInDegree$p(DependencyGraph $this) {
        return $this.inDegree;
    }

    public static final /* synthetic */ LinkedHashMap access$getNodes$p(DependencyGraph $this) {
        return $this.nodes;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/autonomousapps/graph/DependencyGraph$Companion;", "", "()V", "newGraph", "Lcom/autonomousapps/graph/DependencyGraph;", "edges", "", "Lcom/autonomousapps/graph/Edge;", "dependency-analysis-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final DependencyGraph newGraph(@NotNull Iterable<Edge> edges) {
            Intrinsics.checkParameterIsNotNull(edges, (String)"edges");
            DependencyGraph graph = new DependencyGraph();
            Iterable<Edge> $this$forEach$iv = edges;
            boolean $i$f$forEach = false;
            Iterator<Edge> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Edge element$iv;
                Edge it = element$iv = iterator.next();
                boolean bl = false;
                graph.addEdge(it);
            }
            return graph;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

