/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.DependencyGraphKt;
import com.autonomousapps.graph.Edge;
import com.autonomousapps.graph.Node;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u001bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u001bH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/autonomousapps/graph/DepthFirstOrder;", "", "graph", "Lcom/autonomousapps/graph/DependencyGraph;", "(Lcom/autonomousapps/graph/DependencyGraph;)V", "logger", "Lorg/gradle/api/logging/Logger;", "marked", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "post", "", "postCounter", "postorder", "Ljava/util/Queue;", "pre", "preCounter", "preorder", "check", "dfs", "", "node", "Lcom/autonomousapps/graph/Node;", "isMarked", "identifier", "", "reversePost", "dependency-analysis-gradle-plugin"})
public final class DepthFirstOrder {
    private final Logger logger;
    private final LinkedHashMap<String, Boolean> marked;
    private final LinkedHashMap<String, Integer> pre;
    private final LinkedHashMap<String, Integer> post;
    private final Queue<String> preorder;
    private final Queue<String> postorder;
    private int preCounter;
    private int postCounter;
    private final DependencyGraph graph;

    private final boolean isMarked(Node node) {
        return this.isMarked(node.getIdentifier());
    }

    private final boolean isMarked(String identifier) {
        Boolean bl = this.marked.getOrDefault(identifier, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"marked.getOrDefault(identifier, false)");
        return bl;
    }

    private final void dfs(Node node) {
        ((Map)this.marked).put(node.getIdentifier(), true);
        int n = this.preCounter;
        this.preCounter = n + 1;
        ((Map)this.pre).put(node.getIdentifier(), n);
        this.preorder.add(node.getIdentifier());
        for (Edge edge : this.graph.adj(node)) {
            Node to = edge.getTo();
            if (this.isMarked(to)) continue;
            this.dfs(to);
        }
        this.postorder.add(node.getIdentifier());
        n = this.postCounter;
        this.postCounter = n + 1;
        ((Map)this.post).put(node.getIdentifier(), n);
    }

    private final int pre(String node) {
        Integer n = this.pre.get(node);
        if (n == null) {
            Void void_ = DependencyGraphKt.missingNode(node);
            throw null;
        }
        return n;
    }

    private final int post(String node) {
        Integer n = this.post.get(node);
        if (n == null) {
            Void void_ = DependencyGraphKt.missingNode(node);
            throw null;
        }
        return n;
    }

    private final Iterable<String> post() {
        return this.postorder;
    }

    private final Iterable<String> pre() {
        return this.preorder;
    }

    @NotNull
    public final Iterable<String> reversePost() {
        ArrayDeque<String> reverse = new ArrayDeque<String>();
        for (String node : this.postorder) {
            reverse.push(node);
        }
        return reverse;
    }

    private final boolean check() {
        int r;
        boolean bl = false;
        for (String node : this.post()) {
            if (this.post(node) != r) {
                this.logger.error("post(" + node + ") and post() inconsistent");
                return false;
            }
            ++r;
        }
        r = 0;
        for (String node : this.pre()) {
            if (this.pre(node) != r) {
                this.logger.error("pre(" + node + ") and pre() inconsistent");
                return false;
            }
            ++r;
        }
        return true;
    }

    public DepthFirstOrder(@NotNull DependencyGraph graph) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        boolean $i$f$getLogger = false;
        Logger logger = Logging.getLogger(DepthFirstOrder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(T::class.java)");
        this.logger = logger;
        $i$f$getLogger = false;
        this.marked = new LinkedHashMap();
        $i$f$getLogger = false;
        this.pre = new LinkedHashMap();
        $i$f$getLogger = false;
        this.post = new LinkedHashMap();
        this.preorder = new LinkedList();
        this.postorder = new LinkedList();
        Iterable<Node> $this$forEach$iv = this.graph.nodes();
        boolean $i$f$forEach = false;
        Iterator<Node> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Node element$iv;
            Node node = element$iv = iterator.next();
            boolean bl = false;
            if (this.isMarked(node)) continue;
            this.dfs(node);
        }
        boolean bl = this.check();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

